/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.kafka;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.messaging.kafka.AbstractfKafkaSshDriver;
import brooklyn.entity.messaging.kafka.KafkaBroker;
import brooklyn.entity.messaging.kafka.KafkaBrokerDriver;
import brooklyn.entity.messaging.kafka.KafkaBrokerImpl;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBrokerSshDriver
extends AbstractfKafkaSshDriver
implements KafkaBrokerDriver {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBrokerSshDriver.class);

    public KafkaBrokerSshDriver(KafkaBrokerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    @Override
    protected Map<String, Integer> getPortMap() {
        return MutableMap.of((Object)"kafkaPort", (Object)this.getKafkaPort());
    }

    @Override
    protected ConfigKey<String> getConfigTemplateKey() {
        return KafkaBroker.KAFKA_BROKER_CONFIG_TEMPLATE;
    }

    @Override
    protected String getConfigFileName() {
        return "server.properties";
    }

    @Override
    protected String getLaunchScriptName() {
        return "kafka-server-start.sh";
    }

    @Override
    protected String getProcessIdentifier() {
        return "kafka\\.Kafka";
    }

    @Override
    public Integer getKafkaPort() {
        return (Integer)this.getEntity().getAttribute((AttributeSensor)KafkaBroker.KAFKA_PORT);
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        UsesJmx.JmxAgentModes jmxAgentMode = (UsesJmx.JmxAgentModes)this.getEntity().getConfig(KafkaBroker.JMX_AGENT_MODE);
        String jmxPort = jmxAgentMode == UsesJmx.JmxAgentModes.NONE ? String.valueOf(this.entity.getAttribute((AttributeSensor)UsesJmx.JMX_PORT)) : String.valueOf(this.entity.getAttribute((AttributeSensor)KafkaBroker.INTERNAL_JMX_PORT));
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"JMX_PORT", (Object)jmxPort).build();
    }
}

