/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.kafka;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.messaging.MessageBroker;
import brooklyn.entity.messaging.kafka.KafkaBroker;
import brooklyn.entity.messaging.kafka.KafkaBrokerDriver;
import brooklyn.entity.messaging.kafka.KafkaTopic;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.zookeeper.ZooKeeperNode;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.jmx.JmxAttributePollConfig;
import brooklyn.event.feed.jmx.JmxFeed;
import brooklyn.event.feed.jmx.JmxHelper;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaBrokerImpl
extends SoftwareProcessImpl
implements MessageBroker,
KafkaBroker {
    private static final Logger log = LoggerFactory.getLogger(KafkaBrokerImpl.class);
    private static final ObjectName SOCKET_SERVER_STATS_MBEAN = JmxHelper.createObjectName((String)"kafka:type=kafka.SocketServerStats");
    private volatile JmxFeed jmxFeed;

    public void init() {
        super.init();
        this.setAttribute(BROKER_ID, Math.abs(this.hashCode()));
    }

    @Override
    public Integer getKafkaPort() {
        return (Integer)this.getAttribute((AttributeSensor)KAFKA_PORT);
    }

    @Override
    public Integer getBrokerId() {
        return (Integer)this.getAttribute(BROKER_ID);
    }

    @Override
    public ZooKeeperNode getZookeeper() {
        return (ZooKeeperNode)this.getConfig(ZOOKEEPER);
    }

    public KafkaTopic createTopic(Map<?, ?> properties) {
        KafkaTopic result = (KafkaTopic)this.addChild(EntitySpec.create(KafkaTopic.class).configure(properties));
        Entities.manage((Entity)result);
        result.create();
        return result;
    }

    public Class<?> getDriverInterface() {
        return KafkaBrokerDriver.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForServiceUp(long duration, TimeUnit units) {
        super.waitForServiceUp(duration, units);
        if (((KafkaBrokerDriver)this.getDriver()).isJmxEnabled()) {
            JmxHelper helper = new JmxHelper((EntityLocal)this);
            try {
                helper.assertMBeanExistsEventually(SOCKET_SERVER_STATS_MBEAN, units.toMillis(duration));
            }
            finally {
                helper.terminate();
            }
        }
    }

    protected void connectSensors() {
        this.connectServiceUpIsRunning();
        if (((KafkaBrokerDriver)this.getDriver()).isJmxEnabled()) {
            this.jmxFeed = JmxFeed.builder().entity((EntityLocal)this).period(500L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(FETCH_REQUEST_COUNT).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("NumFetchRequests").onException(Functions.constant((Object)-1L))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(TOTAL_FETCH_TIME).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("TotalFetchRequestMs").onException(Functions.constant((Object)-1L))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(MAX_FETCH_TIME).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("MaxFetchRequestMs").onException(Functions.constant((Object)-1.0))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(PRODUCE_REQUEST_COUNT).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("NumProduceRequests").onException(Functions.constant((Object)-1L))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(TOTAL_PRODUCE_TIME).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("TotalProduceRequestMs").onException(Functions.constant((Object)-1L))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(MAX_PRODUCE_TIME).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("MaxProduceRequestMs").onException(Functions.constant((Object)-1.0))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(BYTES_RECEIVED).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("TotalBytesRead").onException(Functions.constant((Object)-1L))).pollAttribute((JmxAttributePollConfig)new JmxAttributePollConfig(BYTES_SENT).objectName(SOCKET_SERVER_STATS_MBEAN).attributeName("TotalBytesWritten").onException(Functions.constant((Object)-1L))).build();
        }
        this.setBrokerUrl();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        this.disconnectServiceUpIsRunning();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("kafkaPort", (Object)this.getKafkaPort());
    }

    @Override
    public void setBrokerUrl() {
        ZooKeeperNode zookeeper = this.getZookeeper();
        if (zookeeper != null) {
            this.setAttribute(BROKER_URL, String.format("zookeeper://%s:%d", zookeeper.getAttribute(HOSTNAME), zookeeper.getZookeeperPort()));
        } else {
            this.setAttribute(BROKER_URL, String.format("kafka://%s:%d", this.getAttribute(HOSTNAME), this.getKafkaPort()));
        }
    }
}

