/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.kafka;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.messaging.MessageBroker;
import brooklyn.entity.messaging.kafka.Kafka;
import brooklyn.entity.messaging.kafka.KafkaBrokerImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.zookeeper.ZooKeeperNode;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;

@ImplementedBy(value=KafkaBrokerImpl.class)
public interface KafkaBroker
extends SoftwareProcess,
MessageBroker,
UsesJmx,
Kafka {
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.START_TIMEOUT, (Object)Duration.FIVE_MINUTES);
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = Kafka.SUGGESTED_VERSION;
    @SetFromFlag(value="kafkaPort")
    public static final PortAttributeSensorAndConfigKey KAFKA_PORT = new PortAttributeSensorAndConfigKey("kafka.port", "Kafka port", (Object)"9092+");
    @SetFromFlag(value="kafkaServerConfig")
    public static final ConfigKey<String> KAFKA_BROKER_CONFIG_TEMPLATE = new BasicConfigKey(String.class, "kafka.broker.configTemplate", "Kafka broker configuration template (in freemarker format)", (Object)"classpath://brooklyn/entity/messaging/kafka/server.properties");
    @SetFromFlag(value="zookeeper")
    public static final ConfigKey<ZooKeeperNode> ZOOKEEPER = new BasicConfigKey(ZooKeeperNode.class, "kafka.broker.zookeeper", "Kafka zookeeper entity");
    public static final PortAttributeSensorAndConfigKey INTERNAL_JMX_PORT = new PortAttributeSensorAndConfigKey("internal.jmx.direct.port", "JMX internal port (started by Kafka broker, if using UsesJmx.JMX_AGENT_MODE is not null)", (Object)PortRanges.fromString((String)"9999+"));
    public static final AttributeSensor<Integer> BROKER_ID = Sensors.newIntegerSensor((String)"kafka.broker.id", (String)"Kafka unique broker ID");
    public static final AttributeSensor<Long> FETCH_REQUEST_COUNT = Sensors.newLongSensor((String)"kafka.broker.fetch.total", (String)"Fetch request count");
    public static final AttributeSensor<Long> TOTAL_FETCH_TIME = Sensors.newLongSensor((String)"kafka.broker.fetch.time.total", (String)"Total fetch request processing time (millis)");
    public static final AttributeSensor<Double> MAX_FETCH_TIME = Sensors.newDoubleSensor((String)"kafka.broker.fetch.time.max", (String)"Max fetch request processing time (millis)");
    public static final AttributeSensor<Long> PRODUCE_REQUEST_COUNT = Sensors.newLongSensor((String)"kafka.broker.produce.total", (String)"Produce request count");
    public static final AttributeSensor<Long> TOTAL_PRODUCE_TIME = Sensors.newLongSensor((String)"kafka.broker.produce.time.total", (String)"Total produce request processing time (millis)");
    public static final AttributeSensor<Double> MAX_PRODUCE_TIME = Sensors.newDoubleSensor((String)"kafka.broker.produce.time.max", (String)"Max produce request processing time (millis)");
    public static final AttributeSensor<Long> BYTES_RECEIVED = Sensors.newLongSensor((String)"kafka.broker.bytes.received", (String)"Total bytes received");
    public static final AttributeSensor<Long> BYTES_SENT = Sensors.newLongSensor((String)"kafka.broker.bytes.sent", (String)"Total bytes sent");

    public Integer getKafkaPort();

    public Integer getBrokerId();

    public ZooKeeperNode getZookeeper();
}

