/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.kafka;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import brooklyn.entity.messaging.kafka.Kafka;
import brooklyn.entity.messaging.kafka.KafkaZooKeeperSshDriver;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractfKafkaSshDriver
extends JavaSoftwareProcessSshDriver {
    private static final Logger log = LoggerFactory.getLogger(KafkaZooKeeperSshDriver.class);

    public AbstractfKafkaSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    protected abstract Map<String, Integer> getPortMap();

    protected abstract ConfigKey<String> getConfigTemplateKey();

    protected abstract String getConfigFileName();

    protected abstract String getLaunchScriptName();

    protected abstract String getProcessIdentifier();

    protected String getLogFileLocation() {
        return Os.mergePaths((String[])new String[]{this.getRunDir(), "console.out"});
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("kafka-%s-src", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_TAR);
        commands.add("tar xzfv " + saveAs);
        commands.add("cd " + this.getExpandedInstallDir());
        commands.add("./sbt update");
        commands.add("./sbt package");
        if (this.isV08()) {
            commands.add("./sbt assembly-package-dependency");
        }
        this.newScript((String)"installing").body.append(commands).execute();
    }

    protected boolean isV08() {
        String v = (String)this.getEntity().getConfig(Kafka.SUGGESTED_VERSION);
        return !v.startsWith("0.7.");
    }

    public void customize() {
        Networking.checkPortsValid(this.getPortMap());
        this.newScript((String)"customizing").failOnNonZeroResultCode().body.append((CharSequence)String.format("cp -R %s/* %s", this.getExpandedInstallDir(), this.getRunDir())).execute();
        String config = (String)this.entity.getConfig(this.getConfigTemplateKey());
        this.copyTemplate(config, this.getConfigFileName());
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), (String)"launching").failOnNonZeroResultCode().body.append((CharSequence)String.format("nohup ./bin/%s ./%s > console.out 2>&1 &", this.getLaunchScriptName(), this.getConfigFileName())).execute();
    }

    public String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "kafka.pid"});
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)String.format((String)"ps ax | grep %s | awk '{print $1}' | xargs kill", (Object[])new Object[]{this.getProcessIdentifier()})).body.append((CharSequence)String.format("ps ax | grep %s | awk '{print $1}' | xargs kill -9", this.getProcessIdentifier())).execute();
    }

    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).renameKey((Object)"JAVA_OPTS", (Object)"KAFKA_JMX_OPTS").build();
    }
}

