/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.activemq;

import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import brooklyn.entity.messaging.activemq.ActiveMQBroker;
import brooklyn.entity.messaging.activemq.ActiveMQBrokerImpl;
import brooklyn.entity.messaging.activemq.ActiveMQDriver;
import brooklyn.event.AttributeSensor;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Networking;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ActiveMQSshDriver
extends JavaSoftwareProcessSshDriver
implements ActiveMQDriver {
    public ActiveMQSshDriver(ActiveMQBrokerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "data/activemq.log"});
    }

    @Override
    public String getBrokerName() {
        return (String)this.entity.getAttribute(ActiveMQBroker.BROKER_NAME);
    }

    @Override
    public Integer getOpenWirePort() {
        return (Integer)this.entity.getAttribute((AttributeSensor)ActiveMQBroker.OPEN_WIRE_PORT);
    }

    public String getMirrorUrl() {
        return (String)this.entity.getConfig(ActiveMQBroker.MIRROR_URL);
    }

    protected String getTemplateConfigurationUrl() {
        return (String)this.entity.getAttribute(ActiveMQBroker.TEMPLATE_CONFIGURATION_URL);
    }

    public String getPidFile() {
        return "data/activemq.pid";
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("apache-activemq-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(BashCommands.INSTALL_TAR);
        commands.add("tar xzfv " + saveAs);
        this.newScript((String)"installing").body.append(commands).execute();
    }

    public void customize() {
        Networking.checkPortsValid((Map)ImmutableMap.of((Object)"jmxPort", (Object)this.getJmxPort(), (Object)"openWirePort", (Object)this.getOpenWirePort()));
        this.newScript((String)"customizing").body.append(new CharSequence[]{String.format("cp -R %s/{bin,conf,data,lib,webapps} .", this.getExpandedInstallDir()), "sed -i.bk 's/\\[-z \"$JAVA_HOME\"]/\\[ -z \"$JAVA_HOME\" ]/g' bin/activemq", "sed -i.bk \"s/\\(ACTIVEMQ_HOME..bin.run.jar.*\\)>.dev.null/\\1/\" bin/activemq", "sed -i.bk 's/8161/" + this.getEntity().getAttribute((AttributeSensor)ActiveMQBroker.AMQ_JETTY_PORT) + "/g' conf/jetty.xml"}).execute();
        String destinationConfigFile = Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "conf/activemq.xml"});
        this.copyTemplate(this.getTemplateConfigurationUrl(), destinationConfigFile);
    }

    public void launch() {
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append((CharSequence)"nohup ./bin/activemq start > ./data/activemq-extra.log 2>&1 &").execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "stopping").execute();
    }

    public void kill() {
        this.newScript((Map)ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), "killing").execute();
    }

    public Map<String, String> getShellEnvironment() {
        return MutableMap.builder().putAll(super.getShellEnvironment()).put((Object)"ACTIVEMQ_HOME", (Object)this.getRunDir()).put((Object)"ACTIVEMQ_PIDFILE", (Object)this.getPidFile()).renameKey((Object)"JAVA_OPTS", (Object)"ACTIVEMQ_OPTS").build();
    }
}

