/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.activemq;

import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.messaging.activemq.ActiveMQBroker;
import brooklyn.entity.messaging.activemq.ActiveMQDestination;
import brooklyn.entity.messaging.jms.JMSDestinationImpl;
import brooklyn.event.feed.jmx.JmxFeed;
import brooklyn.event.feed.jmx.JmxHelper;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Preconditions;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class ActiveMQDestinationImpl
extends JMSDestinationImpl
implements ActiveMQDestination {
    protected ObjectName brokerMBeanName;
    protected transient JmxHelper jmxHelper;
    protected volatile JmxFeed jmxFeed;

    @Override
    public void onManagementStarting() {
        super.onManagementStarting();
        String brokerName = this.getBrokerName();
        Preconditions.checkArgument((brokerName != null && !brokerName.isEmpty() ? 1 : 0) != 0, (Object)"ActiveMQ brokerName attribute must be specified");
        try {
            this.brokerMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=" + brokerName);
            this.jmxHelper = new JmxHelper((EntityLocal)this.getParent());
        }
        catch (MalformedObjectNameException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    protected void disconnectSensors() {
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    protected String getBrokerName() {
        Preconditions.checkNotNull((Object)this.getParent(), (Object)"JMS Destination must have a broker parent");
        return (String)this.getParent().getAttribute(ActiveMQBroker.BROKER_NAME);
    }
}

