/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.activemq;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.messaging.activemq.ActiveMQBroker;
import brooklyn.entity.messaging.activemq.ActiveMQDriver;
import brooklyn.entity.messaging.activemq.ActiveMQQueue;
import brooklyn.entity.messaging.activemq.ActiveMQTopic;
import brooklyn.entity.messaging.jms.JMSBrokerImpl;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.jmx.JmxAttributePollConfig;
import brooklyn.event.feed.jmx.JmxFeed;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQBrokerImpl
extends JMSBrokerImpl<ActiveMQQueue, ActiveMQTopic>
implements ActiveMQBroker {
    private static final Logger log = LoggerFactory.getLogger(ActiveMQBrokerImpl.class);
    private volatile JmxFeed jmxFeed;

    public void init() {
        super.init();
        Entities.getRequiredUrlConfig((Entity)this, (ConfigKey.HasConfigKey)TEMPLATE_CONFIGURATION_URL);
    }

    @Override
    public void setBrokerUrl() {
        this.setAttribute(BROKER_URL, String.format("tcp://%s:%d", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)OPEN_WIRE_PORT)));
    }

    public Integer getJmxPort() {
        return !this.isJmxEnabled() ? Integer.valueOf(-1) : (Integer)this.getAttribute((AttributeSensor)UsesJmx.JMX_PORT);
    }

    public String getBrokerName() {
        return (String)this.getAttribute((AttributeSensor)BROKER_NAME);
    }

    public Integer getOpenWirePort() {
        return (Integer)this.getAttribute((AttributeSensor)OPEN_WIRE_PORT);
    }

    public boolean isJmxEnabled() {
        return Boolean.TRUE.equals(this.getConfig(USE_JMX));
    }

    @Override
    public ActiveMQQueue createQueue(Map properties) {
        ActiveMQQueue result = (ActiveMQQueue)this.addChild(EntitySpec.create(ActiveMQQueue.class).configure(properties));
        Entities.manage((Entity)result);
        result.create();
        return result;
    }

    @Override
    public ActiveMQTopic createTopic(Map properties) {
        ActiveMQTopic result = (ActiveMQTopic)this.addChild(EntitySpec.create(ActiveMQTopic.class).configure(properties));
        Entities.manage((Entity)result);
        result.create();
        return result;
    }

    @Override
    protected void connectSensors() {
        this.setAttribute(BROKER_URL, String.format("tcp://%s:%d", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)OPEN_WIRE_PORT)));
        String brokerMbeanName = "org.apache.activemq:type=Broker,brokerName=" + this.getBrokerName();
        this.jmxFeed = JmxFeed.builder().entity((EntityLocal)this).period(500L, TimeUnit.MILLISECONDS).pollAttribute((JmxAttributePollConfig)((JmxAttributePollConfig)new JmxAttributePollConfig(SERVICE_UP).objectName(brokerMbeanName).attributeName("BrokerName").onSuccess(Functions.forPredicate((Predicate)Predicates.notNull()))).onFailureOrException(Functions.constant((Object)false))).build();
    }

    public void disconnectSensors() {
        super.disconnectSensors();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
    }

    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("openWirePort", this.getAttribute((AttributeSensor)OPEN_WIRE_PORT));
    }

    public Class getDriverInterface() {
        return ActiveMQDriver.class;
    }
}

