/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.messaging.activemq;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.messaging.MessageBroker;
import brooklyn.entity.messaging.activemq.ActiveMQBrokerImpl;
import brooklyn.entity.messaging.activemq.ActiveMQQueue;
import brooklyn.entity.messaging.activemq.ActiveMQTopic;
import brooklyn.entity.messaging.jms.JMSBroker;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;

@Catalog(name="ActiveMQ Broker", description="ActiveMQ is an open source message broker which fully implements the Java Message Service 1.1 (JMS)", iconUrl="classpath:///activemq-logo.png")
@ImplementedBy(value=ActiveMQBrokerImpl.class)
public interface ActiveMQBroker
extends SoftwareProcess,
MessageBroker,
UsesJmx,
JMSBroker<ActiveMQQueue, ActiveMQTopic> {
    @SetFromFlag(value="startTimeout")
    public static final ConfigKey<Duration> START_TIMEOUT = SoftwareProcess.START_TIMEOUT;
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"5.10.2");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey((AttributeSensorAndConfigKey)Attributes.DOWNLOAD_URL, "${driver.mirrorUrl}/${version}/apache-activemq-${version}-bin.tar.gz");
    @SetFromFlag(value="mirrorUrl")
    public static final BasicConfigKey<String> MIRROR_URL = new BasicConfigKey(String.class, "activemq.install.mirror.url", "URL of mirror", (Object)"http://www.mirrorservice.org/sites/ftp.apache.org/activemq");
    @SetFromFlag(value="brokerName")
    public static final AttributeSensorAndConfigKey<String, String> BROKER_NAME = ConfigKeys.newStringSensorAndConfigKey((String)"activemq.brokerName", (String)"ActiveMQ Broker Name", (String)"localhost");
    @SetFromFlag(value="openWirePort")
    public static final PortAttributeSensorAndConfigKey OPEN_WIRE_PORT = new PortAttributeSensorAndConfigKey("openwire.port", "OpenWire port", (Object)"61616+");
    @SetFromFlag(value="jettyPort")
    public static final PortAttributeSensorAndConfigKey AMQ_JETTY_PORT = new PortAttributeSensorAndConfigKey("activemq.jetty.port", "jetty port", (Object)"8161+");
    @SetFromFlag(value="jmxUser")
    public static final BasicAttributeSensorAndConfigKey<String> JMX_USER = new BasicAttributeSensorAndConfigKey(UsesJmx.JMX_USER, (Object)"admin");
    @SetFromFlag(value="jmxPassword")
    public static final BasicAttributeSensorAndConfigKey<String> JMX_PASSWORD = new BasicAttributeSensorAndConfigKey(UsesJmx.JMX_PASSWORD, (Object)"admin");
    @SetFromFlag(value="templateConfigurationUrl")
    public static final BasicAttributeSensorAndConfigKey<String> TEMPLATE_CONFIGURATION_URL = new BasicAttributeSensorAndConfigKey(String.class, "activemq.templateConfigurationUrl", "Template file (in freemarker format) for the conf/activemq.xml file", (Object)"classpath://brooklyn/entity/messaging/activemq/activemq.xml");
}

