/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import java.io.InputStream;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.docker.domain.Image;
import org.jclouds.docker.domain.ImageSummary;
import org.jclouds.docker.options.CreateImageOptions;
import org.jclouds.docker.options.DeleteImageOptions;
import org.jclouds.docker.options.ListImageOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Fallback;

@Consumes(value={"application/json"})
@Path(value="/v{jclouds.api-version}")
public interface ImageApi {
    @Named(value="images:list")
    @GET
    @Path(value="/images/json")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<ImageSummary> listImages();

    @Named(value="images:list")
    @GET
    @Path(value="/images/json")
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<ImageSummary> listImages(ListImageOptions var1);

    @Named(value="image:inspect")
    @GET
    @Path(value="/images/{name}/json")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Image inspectImage(@PathParam(value="name") String var1);

    @Named(value="image:create")
    @POST
    @Path(value="/images/create")
    public InputStream createImage(CreateImageOptions var1);

    @Named(value="image:delete")
    @DELETE
    @Path(value="/images/{name}")
    public InputStream deleteImage(@PathParam(value="name") String var1);

    @Named(value="image:delete")
    @DELETE
    @Path(value="/images/{name}")
    public InputStream deleteImage(@PathParam(value="name") String var1, DeleteImageOptions var2);
}

