/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.docker.domain.AutoValue_NetworkSettings;
import org.jclouds.docker.internal.NullSafeCopies;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class NetworkSettings {
    public abstract String ipAddress();

    public abstract int ipPrefixLen();

    public abstract String gateway();

    public abstract String bridge();

    @Nullable
    public abstract String portMapping();

    public abstract Map<String, List<Map<String, String>>> ports();

    NetworkSettings() {
    }

    @SerializedNames(value={"IPAddress", "IPPrefixLen", "Gateway", "Bridge", "PortMapping", "Ports"})
    public static NetworkSettings create(String ipAddress, int ipPrefixLen, String gateway, String bridge, String portMapping, Map<String, List<Map<String, String>>> ports) {
        return new AutoValue_NetworkSettings(ipAddress, ipPrefixLen, gateway, bridge, portMapping, NullSafeCopies.copyOf(ports));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return NetworkSettings.builder().fromNetworkSettings(this);
    }

    public static final class Builder {
        private String ipAddress;
        private int ipPrefixLen;
        private String gateway;
        private String bridge;
        private String portMapping;
        private Map<String, List<Map<String, String>>> ports = ImmutableMap.of();

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder ipPrefixLen(int ipPrefixLen) {
            this.ipPrefixLen = ipPrefixLen;
            return this;
        }

        public Builder gateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder bridge(String bridge) {
            this.bridge = bridge;
            return this;
        }

        public Builder portMapping(String portMapping) {
            this.portMapping = portMapping;
            return this;
        }

        public Builder ports(Map<String, List<Map<String, String>>> ports) {
            this.ports = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(ports, (Object)"ports")));
            return this;
        }

        public NetworkSettings build() {
            return NetworkSettings.create(this.ipAddress, this.ipPrefixLen, this.gateway, this.bridge, this.portMapping, this.ports);
        }

        public Builder fromNetworkSettings(NetworkSettings in) {
            return this.ipAddress(in.ipAddress()).ipPrefixLen(in.ipPrefixLen()).gateway(in.gateway()).bridge(in.bridge()).portMapping(in.portMapping()).ports(in.ports());
        }
    }
}

