/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jclouds.docker.domain.AutoValue_HostConfig;
import org.jclouds.docker.internal.NullSafeCopies;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class HostConfig {
    @Nullable
    public abstract String containerIDFile();

    public abstract List<String> binds();

    public abstract List<Map<String, String>> lxcConf();

    public abstract boolean privileged();

    @Nullable
    public abstract String dns();

    @Nullable
    public abstract String dnsSearch();

    public abstract Map<String, List<Map<String, String>>> portBindings();

    public abstract List<String> links();

    public abstract boolean publishAllPorts();

    public abstract List<String> volumesFrom();

    HostConfig() {
    }

    @SerializedNames(value={"ContainerIDFile", "Binds", "LxcConf", "Privileged", "Dns", "DnsSearch", "PortBindings", "Links", "PublishAllPorts", "VolumesFrom"})
    public static HostConfig create(String containerIDFile, List<String> binds, List<Map<String, String>> lxcConf, boolean privileged, String dns, String dnsSearch, Map<String, List<Map<String, String>>> portBindings, List<String> links, boolean publishAllPorts, List<String> volumesFrom) {
        return new AutoValue_HostConfig(containerIDFile, NullSafeCopies.copyOf(binds), NullSafeCopies.copyOf(lxcConf), privileged, dns, dnsSearch, NullSafeCopies.copyOf(portBindings), NullSafeCopies.copyOf(links), publishAllPorts, NullSafeCopies.copyOf(volumesFrom));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return HostConfig.builder().fromHostConfig(this);
    }

    public static final class Builder {
        private String containerIDFile;
        private List<String> binds = Lists.newArrayList();
        private List<Map<String, String>> lxcConf = Lists.newArrayList();
        private boolean privileged;
        private String dns;
        private String dnsSearch;
        private Map<String, List<Map<String, String>>> portBindings = Maps.newLinkedHashMap();
        private List<String> links = Lists.newArrayList();
        private boolean publishAllPorts;
        private List<String> volumesFrom = Lists.newArrayList();

        public Builder containerIDFile(String containerIDFile) {
            this.containerIDFile = containerIDFile;
            return this;
        }

        public Builder binds(List<String> binds) {
            this.binds.addAll((Collection)Preconditions.checkNotNull(binds, (Object)"binds"));
            return this;
        }

        public Builder lxcConf(List<Map<String, String>> lxcConf) {
            this.lxcConf.addAll((Collection)Preconditions.checkNotNull(lxcConf, (Object)"lxcConf"));
            return this;
        }

        public Builder privileged(boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Builder dns(String dns) {
            this.dns = dns;
            return this;
        }

        public Builder dnsSearch(String dnsSearch) {
            this.dnsSearch = dnsSearch;
            return this;
        }

        public Builder links(List<String> links) {
            this.links.addAll((Collection)Preconditions.checkNotNull(links, (Object)"links"));
            return this;
        }

        public Builder portBindings(Map<String, List<Map<String, String>>> portBindings) {
            this.portBindings.putAll(portBindings);
            return this;
        }

        public Builder publishAllPorts(boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        public Builder volumesFrom(List<String> volumesFrom) {
            this.volumesFrom.addAll((Collection)Preconditions.checkNotNull(volumesFrom, (Object)"volumesFrom"));
            return this;
        }

        public HostConfig build() {
            return HostConfig.create(this.containerIDFile, this.binds, this.lxcConf, this.privileged, this.dns, this.dnsSearch, this.portBindings, this.links, this.publishAllPorts, this.volumesFrom);
        }

        public Builder fromHostConfig(HostConfig in) {
            return this.containerIDFile(in.containerIDFile()).binds(in.binds()).lxcConf(in.lxcConf()).privileged(in.privileged()).dns(in.dns()).dnsSearch(in.dnsSearch()).links(in.links()).portBindings(in.portBindings()).publishAllPorts(in.publishAllPorts()).volumesFrom(in.volumesFrom());
        }
    }
}

