/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jclouds.docker.domain.AutoValue_Config;
import org.jclouds.docker.domain.HostConfig;
import org.jclouds.docker.internal.NullSafeCopies;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Config {
    @Nullable
    public abstract String hostname();

    @Nullable
    public abstract String domainname();

    @Nullable
    public abstract String user();

    public abstract int memory();

    public abstract int memorySwap();

    public abstract int cpuShares();

    public abstract boolean attachStdin();

    public abstract boolean attachStdout();

    public abstract boolean attachStderr();

    public abstract boolean tty();

    public abstract boolean openStdin();

    public abstract boolean stdinOnce();

    public abstract List<String> env();

    public abstract List<String> cmd();

    public abstract List<String> entrypoint();

    public abstract String image();

    public abstract Map<String, ?> volumes();

    @Nullable
    public abstract String workingDir();

    public abstract boolean networkDisabled();

    public abstract Map<String, ?> exposedPorts();

    public abstract List<String> securityOpts();

    @Nullable
    public abstract HostConfig hostConfig();

    public abstract List<String> binds();

    public abstract List<String> links();

    public abstract List<Map<String, String>> lxcConf();

    public abstract Map<String, List<Map<String, String>>> portBindings();

    public abstract boolean publishAllPorts();

    public abstract boolean privileged();

    @Nullable
    public abstract List<String> dns();

    @Nullable
    public abstract String dnsSearch();

    @Nullable
    public abstract String volumesFrom();

    public abstract List<String> capAdd();

    public abstract List<String> capDrop();

    public abstract Map<String, String> restartPolicy();

    @Nullable
    public abstract String networkMode();

    public abstract Map<String, String> devices();

    Config() {
    }

    @SerializedNames(value={"Hostname", "Domainname", "User", "Memory", "MemorySwap", "CpuShares", "AttachStdin", "AttachStdout", "AttachStderr", "Tty", "OpenStdin", "StdinOnce", "Env", "Cmd", "Entrypoint", "Image", "Volumes", "WorkingDir", "NetworkDisabled", "ExposedPorts", "SecurityOpts", "HostConfig", "Binds", "Links", "LxcConf", "PortBindings", "PublishAllPorts", "Privileged", "Dns", "DnsSearch", "VolumesFrom", "CapAdd", "CapDrop", "RestartPolicy", "NetworkMode", "Devices"})
    public static Config create(String hostname, String domainname, String user, int memory, int memorySwap, int cpuShares, boolean attachStdin, boolean attachStdout, boolean attachStderr, boolean tty, boolean openStdin, boolean stdinOnce, List<String> env, List<String> cmd, List<String> entrypoint, String image, Map<String, ?> volumes, String workingDir, boolean networkDisabled, Map<String, ?> exposedPorts, List<String> securityOpts, HostConfig hostConfig, List<String> binds, List<String> links, List<Map<String, String>> lxcConf, Map<String, List<Map<String, String>>> portBindings, boolean publishAllPorts, boolean privileged, List<String> dns, String dnsSearch, String volumesFrom, List<String> capAdd, List<String> capDrop, Map<String, String> restartPolicy, String networkMode, Map<String, String> devices) {
        return new AutoValue_Config(hostname, domainname, user, memory, memorySwap, cpuShares, attachStdin, attachStdout, attachStderr, tty, openStdin, stdinOnce, NullSafeCopies.copyOf(env), NullSafeCopies.copyOf(cmd), NullSafeCopies.copyOf(entrypoint), image, NullSafeCopies.copyOf(volumes), workingDir, networkDisabled, NullSafeCopies.copyOf(exposedPorts), NullSafeCopies.copyOf(securityOpts), hostConfig, NullSafeCopies.copyOf(binds), NullSafeCopies.copyOf(links), NullSafeCopies.copyOf(lxcConf), NullSafeCopies.copyOf(portBindings), publishAllPorts, privileged, NullSafeCopies.copyOf(dns), dnsSearch, volumesFrom, NullSafeCopies.copyOf(capAdd), NullSafeCopies.copyOf(capDrop), NullSafeCopies.copyOf(restartPolicy), networkMode, NullSafeCopies.copyOf(devices));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Config.builder().fromConfig(this);
    }

    public static final class Builder {
        private String hostname;
        private String domainname;
        private String user;
        private int memory;
        private int memorySwap;
        private int cpuShares;
        private boolean attachStdin;
        private boolean attachStdout;
        private boolean attachStderr;
        private boolean tty;
        private boolean openStdin;
        private boolean stdinOnce;
        private List<String> env = Lists.newArrayList();
        private List<String> cmd = Lists.newArrayList();
        private List<String> entrypoint = Lists.newArrayList();
        private String image;
        private Map<String, ?> volumes = Maps.newHashMap();
        private String workingDir;
        private boolean networkDisabled;
        private Map<String, ?> exposedPorts = Maps.newHashMap();
        private List<String> securityOpts = Lists.newArrayList();
        private HostConfig hostConfig;
        private List<String> binds = Lists.newArrayList();
        private List<String> links = Lists.newArrayList();
        private List<Map<String, String>> lxcConf = Lists.newArrayList();
        private Map<String, List<Map<String, String>>> portBindings = Maps.newHashMap();
        private boolean publishAllPorts;
        private boolean privileged;
        private List<String> dns;
        private String dnsSearch;
        private String volumesFrom;
        private List<String> capAdd = Lists.newArrayList();
        private List<String> capDrop = Lists.newArrayList();
        private Map<String, String> restartPolicy = Maps.newHashMap();
        private String networkMode;
        private Map<String, String> devices = Maps.newHashMap();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder domainname(String domainname) {
            this.domainname = domainname;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder memory(int memory) {
            this.memory = memory;
            return this;
        }

        public Builder memorySwap(int memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        public Builder cpuShares(int cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        public Builder attachStdin(boolean attachStdin) {
            this.attachStdin = attachStdin;
            return this;
        }

        public Builder attachStdout(boolean attachStdout) {
            this.attachStdout = attachStdout;
            return this;
        }

        public Builder attachStderr(boolean attachStderr) {
            this.attachStderr = attachStderr;
            return this;
        }

        public Builder tty(boolean tty) {
            this.tty = tty;
            return this;
        }

        public Builder openStdin(boolean openStdin) {
            this.openStdin = openStdin;
            return this;
        }

        public Builder stdinOnce(boolean stdinOnce) {
            this.stdinOnce = stdinOnce;
            return this;
        }

        public Builder env(List<String> env) {
            this.env = env;
            return this;
        }

        public Builder cmd(List<String> cmd) {
            this.cmd = cmd;
            return this;
        }

        public Builder entrypoint(List<String> entrypoint) {
            this.entrypoint = entrypoint;
            return this;
        }

        public Builder image(String image) {
            this.image = (String)Preconditions.checkNotNull((Object)image, (Object)"image");
            return this;
        }

        public Builder volumes(Map<String, ?> volumes) {
            this.volumes = volumes;
            return this;
        }

        public Builder workingDir(String workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        public Builder networkDisabled(boolean networkDisabled) {
            this.networkDisabled = networkDisabled;
            return this;
        }

        public Builder exposedPorts(Map<String, ?> exposedPorts) {
            this.exposedPorts = exposedPorts;
            return this;
        }

        public Builder securityOpts(List<String> securityOpts) {
            this.securityOpts = securityOpts;
            return this;
        }

        public Builder hostConfig(HostConfig hostConfig) {
            this.hostConfig = (HostConfig)Preconditions.checkNotNull((Object)hostConfig, (Object)"hostConfig");
            return this;
        }

        public Builder binds(List<String> binds) {
            this.binds = binds;
            return this;
        }

        public Builder links(List<String> links) {
            this.links = links;
            return this;
        }

        public Builder lxcConf(List<Map<String, String>> lxcConf) {
            this.lxcConf = lxcConf;
            return this;
        }

        public Builder portBindings(Map<String, List<Map<String, String>>> portBindings) {
            this.portBindings = portBindings;
            return this;
        }

        public Builder publishAllPorts(boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        public Builder privileged(boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public Builder dns(List<String> dns) {
            this.dns = dns;
            return this;
        }

        public Builder dnsSearch(String dnsSearch) {
            this.dnsSearch = dnsSearch;
            return this;
        }

        public Builder volumesFrom(String volumesFrom) {
            this.volumesFrom = volumesFrom;
            return this;
        }

        public Builder capAdd(List<String> capAdd) {
            this.capAdd = capAdd;
            return this;
        }

        public Builder capDrop(List<String> capDrop) {
            this.capDrop = capDrop;
            return this;
        }

        public Builder restartPolicy(Map<String, String> restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        public Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        public Builder devices(Map<String, String> devices) {
            this.devices = devices;
            return this;
        }

        public Config build() {
            return Config.create(this.hostname, this.domainname, this.user, this.memory, this.memorySwap, this.cpuShares, this.attachStdin, this.attachStdout, this.attachStderr, this.tty, this.openStdin, this.stdinOnce, this.env, this.cmd, this.entrypoint, this.image, this.volumes, this.workingDir, this.networkDisabled, this.exposedPorts, this.securityOpts, this.hostConfig, this.binds, this.links, this.lxcConf, this.portBindings, this.publishAllPorts, this.privileged, this.dns, this.dnsSearch, this.volumesFrom, this.capAdd, this.capDrop, this.restartPolicy, this.networkMode, this.devices);
        }

        public Builder fromConfig(Config in) {
            return this.hostname(in.hostname()).domainname(in.domainname()).user(in.user()).memory(in.memory()).memorySwap(in.memorySwap()).cpuShares(in.cpuShares()).attachStdin(in.attachStdin()).attachStdout(in.attachStdout()).attachStderr(in.attachStderr()).tty(in.tty()).image(in.image()).volumes(in.volumes()).workingDir(in.workingDir()).networkDisabled(in.networkDisabled()).exposedPorts(in.exposedPorts()).securityOpts(in.securityOpts()).hostConfig(in.hostConfig()).binds(in.binds()).links(in.links()).lxcConf(in.lxcConf()).portBindings(in.portBindings()).publishAllPorts(in.publishAllPorts()).privileged(in.privileged()).dns(in.dns()).dnsSearch(in.dnsSearch()).volumesFrom(in.volumesFrom()).capAdd(in.capAdd()).capDrop(in.capDrop()).restartPolicy(in.restartPolicy()).networkMode(in.networkMode()).devices(in.devices());
        }
    }
}

