/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.config;

import com.google.common.collect.ImmutableList;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.TlsVersion;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.docker.suppliers.SSLContextWithKeysSupplier;
import org.jclouds.http.okhttp.OkHttpClientSupplier;

@Singleton
public class DockerOkHttpClientSupplier
implements OkHttpClientSupplier {
    private final SSLContextWithKeysSupplier sslContextWithKeysSupplier;

    @Inject
    DockerOkHttpClientSupplier(SSLContextWithKeysSupplier sslContextWithKeysSupplier) {
        this.sslContextWithKeysSupplier = sslContextWithKeysSupplier;
    }

    public OkHttpClient get() {
        OkHttpClient client = new OkHttpClient();
        ConnectionSpec connectionSpecs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_0, TlsVersion.TLS_1_1, TlsVersion.TLS_1_2}).build();
        client.setConnectionSpecs((List)ImmutableList.of((Object)connectionSpecs));
        client.setSslSocketFactory(this.sslContextWithKeysSupplier.get().getSocketFactory());
        return client;
    }
}

