/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.time;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Time {
    public static final String DATE_FORMAT_PREFERRED = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMAT_STAMP = "yyyyMMdd-HHmmssSSS";
    public static final String DATE_FORMAT_SIMPLE_STAMP = "yyyy-MM-dd-HHmm";
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long MILLIS_IN_YEAR = 31536000000L;
    private static Function<Long, String> dateString = new Function<Long, String>(){

        @Nullable
        public String apply(@Nullable Long input) {
            if (input == null) {
                return null;
            }
            return Time.makeDateString(input);
        }
    };
    private static Function<Long, String> dateStampString = new Function<Long, String>(){

        @Nullable
        public String apply(@Nullable Long input) {
            if (input == null) {
                return null;
            }
            return Time.makeDateStampString(input);
        }
    };
    private static final Function<Long, String> LONG_TO_TIME_STRING_EXACT = new FunctionLongToTimeStringExact();
    @Deprecated
    private static Function<Long, String> timeString = new Function<Long, String>(){

        @Nullable
        public String apply(@Nullable Long input) {
            if (input == null) {
                return null;
            }
            return Time.makeTimeStringExact(input);
        }
    };
    private static final Function<Long, String> LONG_TO_TIME_STRING_ROUNDED = new FunctionLongToTimeStringRounded();
    @Deprecated
    private static Function<Long, String> timeStringRounded = new Function<Long, String>(){

        @Nullable
        public String apply(@Nullable Long input) {
            if (input == null) {
                return null;
            }
            return Time.makeTimeStringRounded(input);
        }
    };
    private static final Function<Duration, String> DURATION_TO_TIME_STRING_ROUNDED = new FunctionDurationToTimeStringRounded();

    public static String makeDateString() {
        return Time.makeDateString(System.currentTimeMillis());
    }

    public static String makeDateString(long date) {
        return new SimpleDateFormat(DATE_FORMAT_PREFERRED).format(new Date(date));
    }

    public static Function<Long, String> toDateString() {
        return dateString;
    }

    public static String makeDateStampString() {
        return Time.makeDateStampString(System.currentTimeMillis());
    }

    public static String makeDateStampString(long date) {
        return new SimpleDateFormat(DATE_FORMAT_STAMP).format(new Date(date));
    }

    public static String makeDateSimpleStampString() {
        return Time.makeDateSimpleStampString(System.currentTimeMillis());
    }

    public static String makeDateSimpleStampString(long date) {
        return new SimpleDateFormat(DATE_FORMAT_SIMPLE_STAMP).format(new Date(date));
    }

    public static Function<Long, String> toDateStampString() {
        return dateStampString;
    }

    public static String makeTimeStringExact(long t, TimeUnit unit) {
        long nanos = unit.toNanos(t);
        return Time.makeTimeStringNanoExact(nanos);
    }

    public static String makeTimeStringRounded(long t, TimeUnit unit) {
        long nanos = unit.toNanos(t);
        return Time.makeTimeStringNanoRounded(nanos);
    }

    public static String makeTimeStringRounded(Stopwatch timer) {
        return Time.makeTimeStringRounded(timer.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public static String makeTimeStringExact(long t) {
        return Time.makeTimeString(t, false);
    }

    public static String makeTimeStringRounded(long t) {
        return Time.makeTimeString(t, true);
    }

    public static String makeTimeStringRoundedSince(long utc) {
        return Time.makeTimeString(System.currentTimeMillis() - utc, true);
    }

    public static String makeTimeStringExact(Duration d) {
        return Time.makeTimeStringNanoExact(d.toNanoseconds());
    }

    public static String makeTimeStringRounded(Duration d) {
        return Time.makeTimeStringNanoRounded(d.toNanoseconds());
    }

    public static String makeTimeString(long t, boolean round) {
        return Time.makeTimeStringNano(t * 1000000L, round);
    }

    public static String makeTimeStringNanoExact(long tn) {
        return Time.makeTimeStringNano(tn, false);
    }

    public static String makeTimeStringNanoRounded(long tn) {
        return Time.makeTimeStringNano(tn, true);
    }

    public static String makeTimeStringNano(long tn, boolean round) {
        if (tn < 0L) {
            return "-" + Time.makeTimeStringNano(-tn, round);
        }
        if (tn == 0L) {
            return "0ms";
        }
        long tnm = tn % 1000000L;
        long t = tn / 1000000L;
        String result = "";
        long d = t / 86400000L;
        long h = (t %= 86400000L) / 3600000L;
        long m = (t %= 3600000L) / 60000L;
        long s = (t %= 60000L) / 1000L;
        long ms = t %= 1000L;
        int segments = 0;
        if (d > 0L) {
            result = result + d + "d ";
            ++segments;
        }
        if (h > 0L) {
            result = result + h + "h ";
            ++segments;
        }
        if (round && segments >= 2) {
            return Strings.removeAllFromEnd(result, " ");
        }
        if (m > 0L) {
            result = result + m + "m ";
            ++segments;
        }
        if (round && (segments >= 2 || d > 0L)) {
            return Strings.removeAllFromEnd(result, " ");
        }
        if (s > 0L) {
            if (ms == 0L && tnm == 0L) {
                result = result + s + "s";
                ++segments;
                return result;
            }
            if (round && segments > 0) {
                result = result + s + "s";
                ++segments;
                return result;
            }
            if (round && s > 10L) {
                result = result + Time.toDecimal(s, (double)ms / 1000.0, 1) + "s";
                ++segments;
                return result;
            }
            if (round) {
                result = result + Time.toDecimal(s, (double)ms / 1000.0, 2) + "s";
                ++segments;
                return result;
            }
            result = result + s + "s ";
        }
        if (round && segments > 0) {
            return Strings.removeAllFromEnd(result, " ");
        }
        if (ms > 0L) {
            if (tnm == 0L) {
                result = result + ms + "ms";
                ++segments;
                return result;
            }
            if (round && ms >= 100L) {
                result = result + Time.toDecimal(ms, (double)tnm / 1000000.0, 1) + "ms";
                ++segments;
                return result;
            }
            if (round && ms >= 10L) {
                result = result + Time.toDecimal(ms, (double)tnm / 1000000.0, 2) + "ms";
                ++segments;
                return result;
            }
            if (round) {
                result = result + Time.toDecimal(ms, (double)tnm / 1000000.0, 3) + "ms";
                ++segments;
                return result;
            }
            result = result + ms + "ms ";
        }
        long us = tnm / 1000L;
        long ns = tnm % 1000L;
        if (us > 0L) {
            if (ns == 0L) {
                result = result + us + "us";
                ++segments;
                return result;
            }
            if (round && us >= 100L) {
                result = result + Time.toDecimal(us, (double)ns / 1000.0, 1) + "us";
                ++segments;
                return result;
            }
            if (round && us >= 10L) {
                result = result + Time.toDecimal(us, (double)ns / 1000.0, 2) + "us";
                ++segments;
                return result;
            }
            if (round) {
                result = result + Time.toDecimal(us, (double)ns / 1000.0, 3) + "us";
                ++segments;
                return result;
            }
            result = result + us + "us ";
        }
        if (ns > 0L) {
            result = result + ns + "ns";
        }
        return Strings.removeAllFromEnd(result, " ");
    }

    public static Function<Long, String> fromLongToTimeStringExact() {
        return LONG_TO_TIME_STRING_EXACT;
    }

    @Deprecated
    public static Function<Long, String> toTimeString() {
        return timeString;
    }

    public static Function<Long, String> fromLongToTimeStringRounded() {
        return LONG_TO_TIME_STRING_ROUNDED;
    }

    @Deprecated
    public static Function<Long, String> toTimeStringRounded() {
        return timeStringRounded;
    }

    public static Function<Duration, String> fromDurationToTimeStringRounded() {
        return DURATION_TO_TIME_STRING_ROUNDED;
    }

    private static String toDecimal(long intPart, double fracPart, int decimalPrecision) {
        long powTen = 1L;
        for (int i = 0; i < decimalPrecision; ++i) {
            powTen *= 10L;
        }
        long fpr = Math.round(fracPart * (double)powTen);
        if (fpr == powTen) {
            ++intPart;
            fpr = 0L;
        }
        return intPart + "." + Strings.makePaddedString("" + fpr, decimalPrecision, "0", "");
    }

    public static void sleep(long millis) {
        try {
            if (millis > 0L) {
                Thread.sleep(millis);
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate(e);
        }
    }

    public static void sleep(Duration duration) {
        Time.sleep(duration.toMillisecondsRoundingUp());
    }

    public static long getTimeOfDayFromUtc(long timeUtc) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        gregorianCalendar.setTimeInMillis(timeUtc);
        int hour = gregorianCalendar.get(11);
        int min = gregorianCalendar.get(12);
        int sec = gregorianCalendar.get(13);
        int millis = gregorianCalendar.get(14);
        return ((hour * 60 + min) * 60 + sec) * 1000 + millis;
    }

    public static long getTimeUtc(TimeZone zone, int year, int month, int date, int hourOfDay, int minute, int second, int millis) {
        GregorianCalendar time = new GregorianCalendar(zone);
        time.set(year, month, date, hourOfDay, minute, second);
        time.set(14, millis);
        return time.getTimeInMillis();
    }

    public static long roundFromMillis(long millis, TimeUnit units) {
        if (units.compareTo(TimeUnit.MILLISECONDS) > 0) {
            double result = (double)millis / (double)units.toMillis(1L);
            return Math.round(result);
        }
        return units.convert(millis, TimeUnit.MILLISECONDS);
    }

    public static long roundFromMillis(long millis, long millisPerUnit) {
        double result = (double)millis / (double)millisPerUnit;
        return Math.round(result);
    }

    public static long timeRemaining(long startTime, long maxTime) {
        if (maxTime == 0L) {
            return 0L;
        }
        long result = startTime + maxTime - System.currentTimeMillis();
        return result == 0L ? -1L : result;
    }

    public static long parseTimeString(String timeString) {
        return (long)Time.parseTimeStringAsDouble(timeString);
    }

    public static double parseTimeStringAsDouble(String timeString) {
        if (timeString == null) {
            throw new NumberFormatException("GeneralHelper.parseTimeString cannot parse a null string");
        }
        try {
            double d = Double.parseDouble(timeString);
            return d;
        }
        catch (NumberFormatException e) {
            char c;
            int i;
            timeString = timeString.trim();
            String s = Strings.getLastWord(timeString).toLowerCase();
            timeString = timeString.substring(0, timeString.length() - s.length()).trim();
            for (i = 0; s.length() > i && ((c = s.charAt(i)) == '.' || Character.isDigit(c)); ++i) {
            }
            String num = s.substring(0, i);
            if (i == 0) {
                num = Strings.getLastWord(timeString).toLowerCase();
                timeString = timeString.substring(0, timeString.length() - num.length()).trim();
            } else {
                s = s.substring(i);
            }
            long multiplier = 0L;
            if (num.length() == 0) {
                if (s.equalsIgnoreCase("never") || s.equalsIgnoreCase("off") || s.equalsIgnoreCase("false")) {
                    return -1.0;
                }
                throw new NumberFormatException("unrecognised word  '" + s + "' in time string");
            }
            if (s.equalsIgnoreCase("ms") || s.equalsIgnoreCase("milli") || s.equalsIgnoreCase("millis") || s.equalsIgnoreCase("millisec") || s.equalsIgnoreCase("millisecs") || s.equalsIgnoreCase("millisecond") || s.equalsIgnoreCase("milliseconds")) {
                multiplier = 1L;
            } else if (s.equalsIgnoreCase("s") || s.equalsIgnoreCase("sec") || s.equalsIgnoreCase("secs") || s.equalsIgnoreCase("second") || s.equalsIgnoreCase("seconds")) {
                multiplier = 1000L;
            } else if (s.equalsIgnoreCase("m") || s.equalsIgnoreCase("min") || s.equalsIgnoreCase("mins") || s.equalsIgnoreCase("minute") || s.equalsIgnoreCase("minutes")) {
                multiplier = 60000L;
            } else if (s.equalsIgnoreCase("h") || s.equalsIgnoreCase("hr") || s.equalsIgnoreCase("hrs") || s.equalsIgnoreCase("hour") || s.equalsIgnoreCase("hours")) {
                multiplier = 3600000L;
            } else if (s.equalsIgnoreCase("d") || s.equalsIgnoreCase("day") || s.equalsIgnoreCase("days")) {
                multiplier = 86400000L;
            } else {
                throw new NumberFormatException("unknown unit '" + s + "' in time string");
            }
            double d = Double.parseDouble(num);
            double dd = 0.0;
            if (timeString.length() > 0 && (dd = Time.parseTimeStringAsDouble(timeString)) == -1.0) {
                throw new NumberFormatException("cannot combine '" + timeString + "' with '" + num + " " + s + "'");
            }
            return d * (double)multiplier + dd;
        }
    }

    public static Date parseDateString(String dateString, DateFormat format) {
        if (dateString == null) {
            throw new NumberFormatException("GeneralHelper.parseDateString cannot parse a null string");
        }
        try {
            return format.parse(dateString);
        }
        catch (ParseException e) {
            try {
                String transformedDateString = dateString.replace(" ", "+");
                return format.parse(transformedDateString);
            }
            catch (ParseException e2) {
                try {
                    return new Date(Long.parseLong(dateString.trim()));
                }
                catch (NumberFormatException e3) {
                    throw new IllegalArgumentException("Date " + dateString + " cannot be parsed as UTC millis or using format " + format);
                }
            }
        }
    }

    public static Date dropMilliseconds(Date date) {
        return date == null ? null : (date.getTime() % 1000L != 0L ? new Date(date.getTime() - date.getTime() % 1000L) : date);
    }

    public static Duration elapsedSince(long timestamp) {
        return Duration.millis(System.currentTimeMillis() - timestamp);
    }

    public static boolean hasElapsedSince(long timestamp, Duration duration) {
        return Time.elapsedSince(timestamp).compareTo(duration) > 0;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    private static final class FunctionDurationToTimeStringRounded
    implements Function<Duration, String> {
        private FunctionDurationToTimeStringRounded() {
        }

        @Nullable
        public String apply(@Nullable Duration input) {
            if (input == null) {
                return null;
            }
            return Time.makeTimeStringRounded(input);
        }
    }

    private static final class FunctionLongToTimeStringRounded
    implements Function<Long, String> {
        private FunctionLongToTimeStringRounded() {
        }

        @Nullable
        public String apply(@Nullable Long input) {
            if (input == null) {
                return null;
            }
            return Time.makeTimeStringRounded(input);
        }
    }

    private static final class FunctionLongToTimeStringExact
    implements Function<Long, String> {
        private FunctionLongToTimeStringExact() {
        }

        @Nullable
        public String apply(@Nullable Long input) {
            if (input == null) {
                return null;
            }
            return Time.makeTimeStringExact(input);
        }
    }
}

