/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.time;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Durations {
    public static boolean await(CountDownLatch latch, Duration time) throws InterruptedException {
        return latch.await(time.toNanoseconds(), TimeUnit.NANOSECONDS);
    }

    public static void join(Thread thread, Duration time) throws InterruptedException {
        thread.join(time.toMillisecondsRoundingUp());
    }

    public static <T> Maybe<T> get(Future<T> t, Duration timeout) {
        try {
            if (timeout == null || timeout.toMilliseconds() < 0L || Duration.PRACTICALLY_FOREVER.equals(timeout)) {
                return Maybe.of(t.get());
            }
            if (timeout.toMilliseconds() == 0L && !t.isDone()) {
                return Maybe.absent("Task " + t + " not completed when immediate completion requested");
            }
            return Maybe.of(t.get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS));
        }
        catch (TimeoutException e) {
            return Maybe.absent("Task " + t + " did not complete within " + timeout);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public static <T> Maybe<T> get(Future<T> t, CountdownTimer timer) {
        if (timer == null) {
            return Durations.get(t, (Duration)null);
        }
        Duration remaining = timer.getDurationRemaining();
        if (remaining.isPositive()) {
            return Durations.get(t, remaining);
        }
        return Durations.get(t, Duration.ZERO);
    }
}

