/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.time;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.time.Duration;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;

public class CountdownTimer {
    Stopwatch stopwatch = Stopwatch.createUnstarted();
    Duration limit;

    private CountdownTimer(Duration limit) {
        this.limit = limit;
    }

    public synchronized CountdownTimer start() {
        if (!this.stopwatch.isRunning()) {
            this.stopwatch.start();
        }
        return this;
    }

    public synchronized CountdownTimer pause() {
        if (this.stopwatch.isRunning()) {
            this.stopwatch.stop();
        }
        return this;
    }

    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    public Duration getLimit() {
        return this.limit;
    }

    public Duration getDurationElapsed() {
        return Duration.nanos(this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
    }

    public Duration getDurationRemaining() {
        return Duration.millis(this.limit.toMilliseconds() - this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public boolean isExpired() {
        return this.stopwatch.elapsed(TimeUnit.MILLISECONDS) > this.limit.toMilliseconds();
    }

    public boolean isRunning() {
        return this.stopwatch.isRunning();
    }

    public static CountdownTimer newInstanceStarted(Duration duration) {
        return new CountdownTimer(duration).start();
    }

    public static CountdownTimer newInstancePaused(Duration duration) {
        return new CountdownTimer(duration).pause();
    }

    public synchronized void waitForExpiry() throws InterruptedException {
        while (this.waitOnForExpiry(this)) {
        }
    }

    public synchronized void waitForExpiryUnchecked() {
        this.waitOnForExpiryUnchecked(this);
    }

    public boolean waitOnForExpiry(Object waitTarget) throws InterruptedException {
        Duration remainder = this.getDurationRemaining();
        if (remainder.toMilliseconds() <= 0L) {
            return false;
        }
        waitTarget.wait(remainder.toMilliseconds());
        return true;
    }

    public boolean waitOnForExpiryUnchecked(Object waitTarget) {
        try {
            return this.waitOnForExpiry(waitTarget);
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate(e);
        }
    }
}

