/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.guava.Maybe;
import brooklyn.util.text.ByteSizeStrings;
import brooklyn.util.text.FormattedString;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.QuotedStringTokenizer;
import brooklyn.util.text.StringFunctions;
import brooklyn.util.text.StringShortener;
import brooklyn.util.time.Time;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Ordering;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nullable;

public class Strings {
    public static final String EMPTY = "";
    public static final String VALID_NON_ALPHANUM_FILE_CHARS = "-_.";
    public static final CharMatcher IS_JAVA_IDENTIFIER_PART = CharMatcher.forPredicate((Predicate)new Predicate<Character>(){

        public boolean apply(@Nullable Character input) {
            return input != null && Character.isJavaIdentifierPart(input.charValue());
        }
    });

    public static boolean isEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean isBlank(CharSequence s) {
        return Strings.isEmpty(s) || CharMatcher.WHITESPACE.matchesAllOf(s);
    }

    public static boolean isNonEmpty(CharSequence s) {
        return !Strings.isEmpty(s);
    }

    public static boolean isNonBlank(CharSequence s) {
        return !Strings.isBlank(s);
    }

    public static <T extends CharSequence> Maybe<T> maybeNonBlank(T s) {
        if (Strings.isNonBlank(s)) {
            return Maybe.of(s);
        }
        return Maybe.absent();
    }

    public static void checkNonEmpty(CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException("String must not be null");
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("String must not be empty");
        }
    }

    public static void checkNonEmpty(CharSequence s, String message) {
        if (Strings.isEmpty(s)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static String removeFromEnd(String string, String suffix) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        if (!Strings.isEmpty(suffix) && string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    @Deprecated
    public static String removeFromEnd(String string, String ... suffixes) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        for (String suffix : suffixes) {
            if (suffix == null || !string.endsWith(suffix)) continue;
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String removeAllFromEnd(String string, String ... suffixes) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        int index = string.length();
        boolean anotherLoopNeeded = true;
        block0: while (anotherLoopNeeded) {
            if (Strings.isEmpty(string)) {
                return string;
            }
            anotherLoopNeeded = false;
            for (String suffix : suffixes) {
                if (Strings.isEmpty(suffix) || !string.startsWith(suffix, index - suffix.length())) continue;
                index -= suffix.length();
                anotherLoopNeeded = true;
                continue block0;
            }
        }
        return string.substring(0, index);
    }

    public static String removeFromStart(String string, String prefix) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        if (!Strings.isEmpty(prefix) && string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    @Deprecated
    public static String removeFromStart(String string, String ... prefixes) {
        if (Strings.isEmpty(string)) {
            return string;
        }
        for (String prefix : prefixes) {
            if (prefix == null || !string.startsWith(prefix)) continue;
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String removeAllFromStart(String string, String ... prefixes) {
        int index = 0;
        boolean anotherLoopNeeded = true;
        block0: while (anotherLoopNeeded) {
            if (Strings.isEmpty(string)) {
                return string;
            }
            anotherLoopNeeded = false;
            for (String prefix : prefixes) {
                if (Strings.isEmpty(prefix) || !string.startsWith(prefix, index)) continue;
                index += prefix.length();
                anotherLoopNeeded = true;
                continue block0;
            }
        }
        return string.substring(index);
    }

    public static String join(Iterable<? extends Object> list, String separator) {
        if (list == null) {
            return null;
        }
        boolean app = false;
        StringBuilder out = new StringBuilder();
        for (Object object : list) {
            if (app) {
                out.append(separator);
            }
            out.append(object);
            app = true;
        }
        return out.toString();
    }

    public static String join(Object[] list, String separator) {
        boolean app = false;
        StringBuilder out = new StringBuilder();
        for (Object s : list) {
            if (app) {
                out.append(separator);
            }
            out.append(s);
            app = true;
        }
        return out.toString();
    }

    public static String lines(String ... lines) {
        return Joiner.on((String)"\n").join(Arrays.asList(lines));
    }

    public static String replaceAll(String source, Map replacements) {
        Iterator i$ = replacements.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry rr;
            Map.Entry r = rr = i$.next();
            source = Strings.replaceAllNonRegex(source, EMPTY + r.getKey(), EMPTY + r.getValue());
        }
        return source;
    }

    public static String replaceAll(String source, String pattern, String replacement) {
        if (source == null) {
            return source;
        }
        StringBuilder result = new StringBuilder(source.length());
        int i = 0;
        while (i < source.length()) {
            if (source.substring(i).startsWith(pattern)) {
                result.append(replacement);
                i += pattern.length();
                continue;
            }
            result.append(source.charAt(i));
            ++i;
        }
        return result.toString();
    }

    public static String replaceAllNonRegex(String source, String pattern, String replacement) {
        return Strings.replaceAll(source, pattern, replacement);
    }

    public static String replaceAllRegex(String source, String pattern, String replacement) {
        return source.replaceAll(pattern, replacement);
    }

    public static String makeValidFilename(String s) {
        Preconditions.checkNotNull((Object)s, (Object)"Cannot make valid filename from null string");
        Preconditions.checkArgument((boolean)Strings.isNonBlank(s), (Object)"Cannot make valid filename from blank string");
        return CharMatcher.anyOf((CharSequence)VALID_NON_ALPHANUM_FILE_CHARS).or(CharMatcher.JAVA_LETTER_OR_DIGIT).negate().trimAndCollapseFrom((CharSequence)s, '_');
    }

    public static String makeValidJavaName(String s) {
        if (s == null) {
            return "__null";
        }
        if (s.length() == 0) {
            return "__empty";
        }
        String name = IS_JAVA_IDENTIFIER_PART.negate().collapseFrom((CharSequence)CharMatcher.is((char)'\'').removeFrom((CharSequence)s), '_');
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return "_" + name;
        }
        return name;
    }

    public static String makeValidUniqueJavaName(String s) {
        String name = Strings.makeValidJavaName(s);
        if (Strings.isEmpty(s) || IS_JAVA_IDENTIFIER_PART.matchesAllOf((CharSequence)s) || CharMatcher.is((char)'\'').matchesNoneOf((CharSequence)s)) {
            return name;
        }
        return name + "_" + s.hashCode();
    }

    public static String makeRandomId(int l) {
        return Identifiers.makeRandomId(l);
    }

    public static String makeZeroPaddedString(int i, int len) {
        return Strings.makePaddedString(EMPTY + i, len, "0", EMPTY);
    }

    public static String makePaddedString(String base, int len, String left_pad, String right_pad) {
        String s = EMPTY + (base == null ? EMPTY : base);
        while (s.length() < len) {
            s = left_pad + s + right_pad;
        }
        return s;
    }

    public static void trimAll(String[] s) {
        for (int i = 0; i < s.length; ++i) {
            s[i] = s[i] == null ? EMPTY : s[i].trim();
        }
    }

    public static String makeRealString(double x, int maxlen, int prec, int leftPadLen) {
        return Strings.makeRealString(x, maxlen, prec, leftPadLen, 1.0E-11, true);
    }

    public static String makeRealString(double x, int maxlen, int prec, int leftPadLen, double skipDecimalThreshhold, boolean useEForSmallNumbers) {
        String s;
        if (x < 0.0) {
            return "-" + Strings.makeRealString(-x, maxlen, prec, leftPadLen);
        }
        NumberFormat df = DecimalFormat.getInstance();
        df.setMinimumFractionDigits(0);
        df.setMinimumIntegerDigits(1);
        df.setGroupingUsed(false);
        if (x == 0.0) {
            if (skipDecimalThreshhold > 0.0 || prec <= 1) {
                s = "0";
            } else {
                s = "0.0";
                while (s.length() < prec + 1) {
                    s = s + "0";
                }
            }
        } else {
            int numFractionDigits;
            int log = (int)Math.floor(Math.log10(x));
            int n = numFractionDigits = log >= prec ? 0 : prec - log - 1;
            if (numFractionDigits > 0) {
                if (skipDecimalThreshhold > 0.0) {
                    int checkFractionDigits = 0;
                    double multiplier = 1.0;
                    while (checkFractionDigits < numFractionDigits && !(Math.abs(x - Math.rint(x * multiplier) / multiplier) < skipDecimalThreshhold)) {
                        ++checkFractionDigits;
                        multiplier *= 10.0;
                    }
                    numFractionDigits = checkFractionDigits;
                }
                df.setMinimumFractionDigits(numFractionDigits);
                df.setMaximumFractionDigits(numFractionDigits);
            } else {
                df.setMaximumFractionDigits(0);
            }
            s = df.format(x);
            if (maxlen > 0 && s.length() > maxlen) {
                double signif = x / Math.pow(10.0, log);
                if (s.indexOf(Strings.getDefaultDecimalSeparator()) >= 0) {
                    if (Math.abs(x) < 1.0 && useEForSmallNumbers) {
                        s = Strings.makeRealString(signif, -1, prec, -1) + "E" + log;
                    }
                } else {
                    s = Strings.makeRealString(signif, -1, prec, -1) + "E" + log;
                }
            }
        }
        if (leftPadLen > s.length()) {
            return Strings.makePaddedString(s, leftPadLen, " ", EMPTY);
        }
        return s;
    }

    public static String makeRealStringNearZero(double x, int maxlen, int prec, int leftPadLen) {
        String s;
        if (Math.abs(x) < 1.0E-10) {
            x = 0.0;
        }
        NumberFormat df = DecimalFormat.getInstance();
        df.setMinimumFractionDigits(0);
        df.setMinimumIntegerDigits(1);
        df.setGroupingUsed(false);
        if (x == 0.0) {
            if (prec <= 1) {
                s = "0";
            } else {
                s = "0.0";
                while (s.length() < prec + 1) {
                    s = s + "0";
                }
            }
        } else {
            int scale;
            int log = (int)Math.floor(Math.log10(x));
            int n = scale = log >= prec ? 0 : prec - log - 1;
            if (scale > 0) {
                double scale10 = Math.pow(10.0, scale);
                x = Math.rint(x * scale10) / scale10;
                df.setMinimumFractionDigits(scale);
                df.setMaximumFractionDigits(scale);
            } else {
                df.setMaximumFractionDigits(0);
            }
            s = df.format(x);
            if (maxlen > 0 && s.length() > maxlen) {
                double signif = x / Math.pow(10.0, log);
                if (s.indexOf(46) >= 0) {
                    if (Math.abs(x) < 1.0) {
                        s = Strings.makeRealString(signif, -1, prec, -1) + "E" + log;
                    }
                } else {
                    s = Strings.makeRealString(signif, -1, prec, -1) + "E" + log;
                }
            }
        }
        if (leftPadLen > s.length()) {
            return Strings.makePaddedString(s, leftPadLen, " ", EMPTY);
        }
        return s;
    }

    public static String getFirstWord(String s) {
        int start;
        if (s == null) {
            return null;
        }
        for (start = 0; start < s.length() && Character.isWhitespace(s.charAt(start)); ++start) {
        }
        int end = start;
        if (end >= s.length()) {
            return null;
        }
        while (end < s.length() && !Character.isWhitespace(s.charAt(end))) {
            ++end;
        }
        return s.substring(start, end);
    }

    public static String getLastWord(String s) {
        int end;
        if (s == null) {
            return null;
        }
        for (end = s.length() - 1; end >= 0 && Character.isWhitespace(s.charAt(end)); --end) {
        }
        int start = end;
        if (start < 0) {
            return null;
        }
        while (start >= 0 && !Character.isWhitespace(s.charAt(start))) {
            --start;
        }
        return s.substring(start + 1, end + 1);
    }

    public static String getFirstWordAfter(String context, String phrase) {
        if (context == null || phrase == null) {
            return null;
        }
        int index = context.indexOf(phrase);
        if (index < 0) {
            return null;
        }
        return Strings.getFirstWord(context.substring(index + phrase.length()));
    }

    public static String getRemainderOfLineAfter(String context, String phrase) {
        if (context == null || phrase == null) {
            return null;
        }
        int index = context.indexOf(phrase);
        if (index < 0) {
            return null;
        }
        int lineEndIndex = context.indexOf("\n", index);
        if (lineEndIndex <= 0) {
            return context.substring(index + phrase.length());
        }
        return context.substring(index + phrase.length(), lineEndIndex);
    }

    @Deprecated
    public static String makeTimeString(long utcMillis) {
        return Time.makeTimeStringRounded(utcMillis);
    }

    public static String[] makeArray(String prefix, int count) {
        String[] result = new String[count];
        int len = (EMPTY + count).length();
        for (int i = 1; i <= count; ++i) {
            result[i - 1] = prefix + Strings.makePaddedString(EMPTY, len, "0", EMPTY + i);
        }
        return result;
    }

    public static String[] combineArrays(String[] ... arrays) {
        int totalLen = 0;
        for (String[] array : arrays) {
            if (array == null) continue;
            totalLen += array.length;
        }
        String[] result = new String[totalLen];
        int i = 0;
        for (String[] array : arrays) {
            if (array == null) continue;
            for (String s : array) {
                result[i++] = s;
            }
        }
        return result;
    }

    public static String toInitialCapOnly(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return value.substring(0, 1).toUpperCase(Locale.ENGLISH) + value.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public static String reverse(String name) {
        return new StringBuffer(name).reverse().toString();
    }

    public static boolean isLowerCase(String s) {
        return s.toLowerCase().equals(s);
    }

    public static String makeRepeated(char c, int length) {
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            result.append(c);
        }
        return result.toString();
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static String trimEnd(String s) {
        if (s == null) {
            return null;
        }
        return ("a" + s).trim().substring(1);
    }

    public static String maxlen(String s, int maxlen) {
        return Strings.maxlenWithEllipsis(s, maxlen, EMPTY);
    }

    public static String maxlenWithEllipsis(String s, int maxlen) {
        return Strings.maxlenWithEllipsis(s, maxlen, "...");
    }

    public static String maxlenWithEllipsis(String s, int maxlen, String ellipsis) {
        if (s == null) {
            return null;
        }
        if (ellipsis == null) {
            ellipsis = EMPTY;
        }
        if (s.length() <= maxlen) {
            return s;
        }
        return s.substring(0, Math.max(maxlen - ellipsis.length(), 0)) + ellipsis;
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public static boolean containsLiteralIgnoreCase(CharSequence input, CharSequence fragment) {
        if (input == null) {
            return false;
        }
        if (Strings.isEmpty(fragment)) {
            return true;
        }
        int lastValidStartPos = input.length() - fragment.length();
        char f0u = Character.toUpperCase(fragment.charAt(0));
        char f0l = Character.toLowerCase(fragment.charAt(0));
        block0: for (int i = 0; i <= lastValidStartPos; ++i) {
            char ii = input.charAt(i);
            if (ii != f0l && ii != f0u) continue;
            for (int j = 1; j < fragment.length(); ++j) {
                if (Character.toLowerCase(input.charAt(i + j)) != Character.toLowerCase(fragment.charAt(j))) continue block0;
            }
            return true;
        }
        return false;
    }

    public static boolean containsLiteral(CharSequence input, CharSequence fragment) {
        if (input == null) {
            return false;
        }
        if (Strings.isEmpty(fragment)) {
            return true;
        }
        int lastValidStartPos = input.length() - fragment.length();
        char f0 = fragment.charAt(0);
        block0: for (int i = 0; i <= lastValidStartPos; ++i) {
            char ii = input.charAt(i);
            if (ii != f0) continue;
            for (int j = 1; j < fragment.length(); ++j) {
                if (input.charAt(i + j) != fragment.charAt(j)) continue block0;
            }
            return true;
        }
        return false;
    }

    public static String makeSizeString(long sizeInBytes) {
        return ByteSizeStrings.metric().makeSizeString(sizeInBytes);
    }

    public static String makeISOSizeString(long sizeInBytes) {
        return ByteSizeStrings.iso().makeSizeString(sizeInBytes);
    }

    public static String makeJavaSizeString(long sizeInBytes) {
        return ByteSizeStrings.java().makeSizeString(sizeInBytes);
    }

    public static StringShortener shortener() {
        return new StringShortener();
    }

    public static Supplier<String> toStringSupplier(Object src) {
        return Suppliers.compose((Function)Functions.toStringFunction(), (Supplier)Suppliers.ofInstance((Object)src));
    }

    public static FormattedString format(String pattern, Object ... args) {
        return new FormattedString(pattern, args);
    }

    public static String s(int count) {
        return count == 1 ? EMPTY : "s";
    }

    public static String s(@Nullable Map<?, ?> x) {
        return Strings.s(x == null ? 0 : x.size());
    }

    public static String s(Iterable<?> x) {
        if (x == null) {
            return Strings.s(0);
        }
        return Strings.s(x.iterator());
    }

    public static String s(Iterator<?> x) {
        int count = 0;
        if (x != null && x.hasNext()) {
            x.next();
            ++count;
            if (x.hasNext()) {
                ++count;
            }
        }
        return Strings.s(count);
    }

    public static String ies(int count) {
        return count == 1 ? "y" : "ies";
    }

    public static String ies(@Nullable Map<?, ?> x) {
        return Strings.ies(x == null ? 0 : x.size());
    }

    public static String ies(Iterable<?> x) {
        if (x == null) {
            return Strings.ies(0);
        }
        return Strings.ies(x.iterator());
    }

    public static String ies(Iterator<?> x) {
        int count = 0;
        if (x != null && x.hasNext()) {
            x.next();
            ++count;
            if (x.hasNext()) {
                ++count;
            }
        }
        return Strings.ies(count);
    }

    public static Map<String, String> toStringMap(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        MutableMap<String, String> result = MutableMap.of();
        for (Map.Entry<?, ?> e : map.entrySet()) {
            result.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
        }
        return result;
    }

    public static String repeat(String base, int count) {
        if (base == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(base);
        }
        return result.toString();
    }

    public static Ordering<String> lengthComparator() {
        return Ordering.natural().onResultOf(StringFunctions.length()).compound((Comparator)Ordering.natural()).nullsFirst();
    }

    public static boolean isMultiLine(String s) {
        if (s == null) {
            return false;
        }
        return s.indexOf(10) >= 0 || s.indexOf(13) >= 0;
    }

    public static String getFirstLine(String s) {
        int idx = s.indexOf(10);
        if (idx == -1) {
            return s;
        }
        return s.substring(0, idx);
    }

    public static String getFragmentBetween(String input, String prefix, String suffix) {
        int index;
        if (input == null) {
            return null;
        }
        if (prefix != null) {
            index = input.indexOf(prefix);
            if (index == -1) {
                return null;
            }
            input = input.substring(index + prefix.length());
        }
        if (suffix != null && (index = input.indexOf(suffix)) >= 0) {
            input = input.substring(0, index);
        }
        return input;
    }

    public static int getWordCount(String phrase, boolean respectQuotes) {
        if (phrase == null) {
            return 0;
        }
        phrase = phrase.trim();
        if (respectQuotes) {
            return new QuotedStringTokenizer(phrase).remainderAsList().size();
        }
        return Collections.list(new StringTokenizer(phrase)).size();
    }

    public static char getDecimalSeparator(Locale locale) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(locale);
        return dfs.getDecimalSeparator();
    }

    public static char getDefaultDecimalSeparator() {
        return Strings.getDecimalSeparator(Locale.getDefault());
    }

    public static String collapseWhitespace(String x, String whitespaceReplacement) {
        if (x == null) {
            return null;
        }
        return Strings.replaceAllRegex(x, "\\s+", whitespaceReplacement);
    }

    public static String toLowerCase(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        return value.toLowerCase(Locale.ENGLISH);
    }

    public static String emptyToNull(String var) {
        if (Strings.isNonEmpty(var)) {
            return var;
        }
        return null;
    }

    public static String toUniqueString(Object x, int optionalMax) {
        if (x instanceof Iterable && !(x instanceof List)) {
            MutableList result = MutableList.of();
            for (Object xi : (Iterable)x) {
                result.add(Strings.toUniqueString(xi, optionalMax));
            }
            Collections.sort(result);
            x = result.toString();
        }
        if (x == null) {
            return "{null}";
        }
        String xs = x.toString();
        if (xs.length() <= optionalMax || optionalMax <= 0) {
            return xs;
        }
        return Strings.maxlenWithEllipsis(xs, optionalMax - 8) + "/" + Integer.toHexString(xs.hashCode());
    }
}

