/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import brooklyn.util.text.Strings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StringShortener {
    protected Map<String, String> wordsByIdInOrder = new LinkedHashMap<String, String>();
    protected String separator = null;
    private List<ShorteningRule> rules = new ArrayList<ShorteningRule>();

    public StringShortener separator(String separator) {
        this.separator = separator;
        return this;
    }

    public StringShortener append(String id, String text) {
        String old = this.wordsByIdInOrder.put(id, text);
        if (old != null) {
            throw new IllegalStateException("Cannot append with id '" + id + "' when id already present");
        }
        return this;
    }

    public StringShortener truncate(String id, int len) {
        String v = this.wordsByIdInOrder.get(id);
        if (v != null && v.length() > len) {
            this.wordsByIdInOrder.put(id, v.substring(0, len));
        }
        return this;
    }

    public StringShortener canTruncate(String id, int len) {
        this.rules.add(new TruncationRule(id, len));
        return this;
    }

    public StringShortener canRemove(String id) {
        this.rules.add(new RemovalRule(id));
        return this;
    }

    public String getStringOfMaxLength(int maxlen) {
        LinkedHashMap<String, String> words = new LinkedHashMap<String, String>();
        words.putAll(this.wordsByIdInOrder);
        int length = 0;
        for (String w : words.values()) {
            if (Strings.isBlank(w)) continue;
            length += w.length();
            if (this.separator == null) continue;
            length += this.separator.length();
        }
        if (this.separator != null && length > 0) {
            length -= this.separator.length();
        }
        ArrayList<ShorteningRule> rulesLeft = new ArrayList<ShorteningRule>();
        rulesLeft.addAll(this.rules);
        while (length > maxlen && !rulesLeft.isEmpty()) {
            ShorteningRule r = (ShorteningRule)rulesLeft.remove(0);
            length = r.apply(words, maxlen, length);
        }
        StringBuilder sb = new StringBuilder();
        for (String w : words.values()) {
            if (Strings.isBlank(w)) continue;
            if (this.separator != null && sb.length() > 0) {
                sb.append(this.separator);
            }
            sb.append(w);
        }
        String result = sb.toString();
        if (result.length() > maxlen) {
            result = result.substring(0, maxlen);
        }
        return result;
    }

    protected class RemovalRule
    implements ShorteningRule {
        String id;

        public RemovalRule(String id) {
            this.id = id;
        }

        @Override
        public int apply(LinkedHashMap<String, String> words, int maxlen, int length) {
            String v = words.get(this.id);
            if (v != null) {
                words.remove(this.id);
                if (StringShortener.this.separator != null && (length -= v.length()) > 0) {
                    length -= StringShortener.this.separator.length();
                }
            }
            return length;
        }
    }

    protected class TruncationRule
    implements ShorteningRule {
        String id;
        int len;

        public TruncationRule(String id, int len) {
            this.id = id;
            this.len = len;
        }

        @Override
        public int apply(LinkedHashMap<String, String> words, int maxlen, int length) {
            String v = words.get(this.id);
            if (v != null && v.length() > this.len) {
                int charsToRemove = v.length() - this.len;
                if (length - charsToRemove < maxlen) {
                    charsToRemove = length - maxlen;
                }
                words.put(this.id, v.substring(0, v.length() - charsToRemove));
                if (charsToRemove == v.length() && StringShortener.this.separator != null && (length -= charsToRemove) > 0) {
                    length -= StringShortener.this.separator.length();
                }
            }
            return length;
        }
    }

    protected static interface ShorteningRule {
        public int apply(LinkedHashMap<String, String> var1, int var2, int var3);
    }
}

