/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import brooklyn.util.text.Strings;
import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class StringFunctions {
    public static Function<String, String> append(final String suffix) {
        return new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String input) {
                if (input == null) {
                    return null;
                }
                return input + suffix;
            }
        };
    }

    public static Function<String, String> prepend(final String prefix) {
        return new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String input) {
                if (input == null) {
                    return null;
                }
                return prefix + input;
            }
        };
    }

    public static Function<Object, String> formatter(final String pattern) {
        return new Function<Object, String>(){

            public String apply(@Nullable Object input) {
                return String.format(pattern, input);
            }
        };
    }

    public static Function<Object[], String> formatterForArray(final String pattern) {
        return new Function<Object[], String>(){

            public String apply(@Nullable Object[] input) {
                return String.format(pattern, input);
            }
        };
    }

    public static Function<Iterable<?>, String> joiner(final String separator) {
        return new Function<Iterable<?>, String>(){

            public String apply(@Nullable Iterable<?> input) {
                return Strings.join(input, separator);
            }
        };
    }

    public static Function<Object[], String> joinerForArray(final String separator) {
        return new Function<Object[], String>(){

            public String apply(@Nullable Object[] input) {
                if (input == null) {
                    return "";
                }
                return Strings.join(input, separator);
            }
        };
    }

    public static Function<Object, String> toStringFunction() {
        return Functions.toStringFunction();
    }

    public static Function<String, Integer> length() {
        return new Function<String, Integer>(){

            public Integer apply(@Nullable String input) {
                if (input == null) {
                    return -1;
                }
                return input.length();
            }
        };
    }

    public static Function<String, String> surround(final String prefix, final String suffix) {
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull((Object)suffix);
        return new Function<String, String>(){

            public String apply(@Nullable String input) {
                if (input == null) {
                    return null;
                }
                return prefix + input + suffix;
            }
        };
    }

    public static Function<String, String> trim() {
        return new Function<String, String>(){

            public String apply(@Nullable String input) {
                if (input == null) {
                    return null;
                }
                if (Strings.isBlank(input)) {
                    return "";
                }
                return CharMatcher.BREAKING_WHITESPACE.trimFrom((CharSequence)input);
            }
        };
    }

    public static Function<String, String> toLowerCase() {
        return new Function<String, String>(){

            public String apply(String input) {
                return input.toLowerCase();
            }
        };
    }

    public static Function<String, String> toUpperCase() {
        return new Function<String, String>(){

            public String apply(String input) {
                return input.toUpperCase();
            }
        };
    }

    public static Function<String, String> convertCase(final CaseFormat src, final CaseFormat target) {
        return new Function<String, String>(){

            public String apply(String input) {
                return src.to(target, input);
            }
        };
    }
}

