/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QuotedStringTokenizer {
    final StringTokenizer delegate;
    final String quoteChars;
    final boolean includeQuotes;
    final String delimiters;
    final boolean includeDelimiters;
    public static String DEFAULT_QUOTE_CHARS = "\"'";
    public static final String DEFAULT_DELIMITERS = " \t\n\r\f";
    String peekedNextToken = null;

    protected String DEFAULT_QUOTE_CHARS() {
        return DEFAULT_QUOTE_CHARS;
    }

    public QuotedStringTokenizer(String stringToTokenize) {
        this(stringToTokenize, true);
    }

    public QuotedStringTokenizer(String stringToTokenize, boolean includeQuotes) {
        this(stringToTokenize, null, includeQuotes);
    }

    public QuotedStringTokenizer(String stringToTokenize, String quoteChars, boolean includeQuotes) {
        this(stringToTokenize, quoteChars, includeQuotes, null, false);
    }

    public QuotedStringTokenizer(String stringToTokenize, String quoteChars, boolean includeQuotes, String delimiters, boolean includeDelimiters) {
        this.delegate = new StringTokenizer(stringToTokenize == null ? "" : stringToTokenize, delimiters == null ? DEFAULT_DELIMITERS : delimiters, true);
        this.quoteChars = quoteChars == null ? this.DEFAULT_QUOTE_CHARS() : quoteChars;
        this.includeQuotes = includeQuotes;
        this.delimiters = delimiters == null ? DEFAULT_DELIMITERS : delimiters;
        this.includeDelimiters = includeDelimiters;
        this.updateNextToken();
    }

    public static Builder builder() {
        return new Builder();
    }

    public synchronized boolean hasMoreTokens() {
        return this.peekedNextToken != null;
    }

    public synchronized String nextToken() {
        if (this.peekedNextToken == null) {
            throw new NoSuchElementException();
        }
        String lastToken = this.peekedNextToken;
        this.updateNextToken();
        return this.includeQuotes ? lastToken : this.unquoteToken(lastToken);
    }

    public String unquoteToken(String word) {
        word = word.replaceAll("((\\A|[^\\\\])(\\\\\\\\)*)[" + this.quoteChars + "]+", "$1");
        word = word.replaceAll("\\\\([\\\\" + this.quoteChars + "])", "$1");
        return word;
    }

    public String quoteToken(String unescapedText) {
        String result = unescapedText;
        result = result.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("([" + this.quoteChars + "])", "\\\\$1");
        result = this.quoteChars.charAt(0) + result + this.quoteChars.charAt(0);
        return result;
    }

    protected synchronized void updateNextToken() {
        String token;
        this.peekedNextToken = null;
        do {
            if (!this.delegate.hasMoreTokens()) {
                return;
            }
            token = this.delegate.nextToken();
        } while (!this.includeDelimiters && token.matches("[" + this.delimiters + "]+"));
        StringBuffer nextToken = new StringBuffer(token);
        this.pullUntilValid(nextToken);
        this.peekedNextToken = nextToken.toString();
    }

    private void pullUntilValid(StringBuffer nextToken) {
        while (QuotedStringTokenizer.hasOpenQuote(nextToken.toString(), this.quoteChars) && this.delegate.hasMoreTokens()) {
            nextToken.append(this.delegate.nextToken());
        }
    }

    public static boolean hasOpenQuote(String stringToCheck) {
        return QuotedStringTokenizer.hasOpenQuote(stringToCheck, DEFAULT_QUOTE_CHARS);
    }

    public static boolean hasOpenQuote(String stringToCheck, String quoteChars) {
        String x = stringToCheck;
        if (x == null) {
            return false;
        }
        StringBuffer xi = new StringBuffer();
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (quoteChars.indexOf(c) < 0) continue;
            xi.append(c);
        }
        x = xi.toString();
        while (x.length() > 0) {
            char c = x.charAt(0);
            int match = x.indexOf(c, 1);
            if (match == -1) {
                return true;
            }
            x = x.substring(match + 1);
        }
        return false;
    }

    public List<String> remainderAsList() {
        ArrayList<String> l = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            l.add(this.nextToken());
        }
        return l;
    }

    public static class Builder {
        private String quoteChars = DEFAULT_QUOTE_CHARS;
        private boolean includeQuotes = true;
        private String delimiterChars = " \t\n\r\f";
        private boolean includeDelimiters = false;

        public QuotedStringTokenizer build(String stringToTokenize) {
            return new QuotedStringTokenizer(stringToTokenize, this.quoteChars, this.includeQuotes, this.delimiterChars, this.includeDelimiters);
        }

        public List<String> buildList(String stringToTokenize) {
            return new QuotedStringTokenizer(stringToTokenize, this.quoteChars, this.includeQuotes, this.delimiterChars, this.includeDelimiters).remainderAsList();
        }

        public Builder quoteChars(String quoteChars) {
            this.quoteChars = quoteChars;
            return this;
        }

        public Builder addQuoteChars(String quoteChars) {
            this.quoteChars = this.quoteChars + quoteChars;
            return this;
        }

        public Builder includeQuotes(boolean includeQuotes) {
            this.includeQuotes = includeQuotes;
            return this;
        }

        public Builder delimiterChars(String delimiterChars) {
            this.delimiterChars = delimiterChars;
            return this;
        }

        public Builder addDelimiterChars(String delimiterChars) {
            this.delimiterChars = this.delimiterChars + delimiterChars;
            return this;
        }

        public Builder includeDelimiters(boolean includeDelimiters) {
            this.includeDelimiters = includeDelimiters;
            return this;
        }
    }
}

