/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import java.util.Random;

public class Identifiers {
    private static Random random = new Random();
    public static final String JAVA_GOOD_START_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_";
    public static final String JAVA_GOOD_NONSTART_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_1234567890";
    public static final String JAVA_GENERATED_IDENTIFIER_START_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String JAVA_GENERATED_IDENTIFIERNONSTART_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
    public static final String BASE64_VALID_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890+=";
    public static final String ID_VALID_START_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String ID_VALID_NONSTART_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";

    public static String makeRandomId(int l) {
        if (l <= 0) {
            return "";
        }
        char[] id = new char[l];
        int d = random.nextInt(768369472);
        int i = 0;
        id[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt(d % 52);
        d /= 52;
        if (++i < l) {
            while (true) {
                id[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890".charAt(d % 62);
                if (++i >= l) break;
                if (i % 5 == 0) {
                    d = random.nextInt(916132832);
                    continue;
                }
                d /= 62;
            }
        }
        return new String(id);
    }

    public static String makeIdFromHash(long d) {
        StringBuffer result = new StringBuffer();
        if (d < 0L) {
            d = -d;
        }
        if (d < 0L) {
            d = -(d + 1000L);
        }
        result.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt((int)(d % 52L)));
        d /= 52L;
        while (d != 0L) {
            result.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890".charAt((int)(d % 62L)));
            d /= 62L;
        }
        return result.toString();
    }

    public static String makeRandomJavaId(int l) {
        if (l <= 0) {
            return "";
        }
        char[] id = new char[l];
        int d = random.nextInt(768369472);
        int i = 0;
        id[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt(d % 52);
        d /= 52;
        if (++i < l) {
            while (true) {
                id[i] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890".charAt(d % 62);
                if (++i >= l) break;
                if (i % 5 == 0) {
                    d = random.nextInt(916132832);
                    continue;
                }
                d /= 62;
            }
        }
        return new String(id);
    }

    public static double randomDouble() {
        return random.nextDouble();
    }

    public static long randomLong() {
        return random.nextLong();
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static int randomInt(int upbound) {
        return random.nextInt(upbound);
    }

    public static byte[] randomBytes(byte[] buf) {
        random.nextBytes(buf);
        return buf;
    }

    public static byte[] randomBytes(int length) {
        byte[] buf = new byte[length];
        return Identifiers.randomBytes(buf);
    }

    public static String makeRandomBase64Id(int length) {
        StringBuilder s = new StringBuilder();
        while (length > 0) {
            Identifiers.appendBase64IdFromValueOfLength(Identifiers.randomLong(), length > 10 ? 10 : length, s);
            length -= 10;
        }
        return s.toString();
    }

    public static String getBase64IdFromValue(long value) {
        return Identifiers.getBase64IdFromValue(value, 10);
    }

    public static String getBase64IdFromValue(long value, int length) {
        StringBuilder s = new StringBuilder();
        Identifiers.appendBase64IdFromValueOfLength(value, length, s);
        return s.toString();
    }

    public static void appendBase64IdFromValueOfLength(long value, int length, StringBuffer sb) {
        if (length > 11) {
            throw new IllegalArgumentException("can't get a Base64 string longer than 11 chars from a long");
        }
        long idx = value;
        for (int i = 0; i < length; ++i) {
            byte x = (byte)(idx & 0x3FL);
            sb.append(BASE64_VALID_CHARS.charAt(x));
            idx >>= 6;
        }
    }

    public static void appendBase64IdFromValueOfLength(long value, int length, StringBuilder sb) {
        if (length > 11) {
            throw new IllegalArgumentException("can't get a Base64 string longer than 11 chars from a long");
        }
        long idx = value;
        for (int i = 0; i < length; ++i) {
            byte x = (byte)(idx & 0x3FL);
            sb.append(BASE64_VALID_CHARS.charAt(x));
            idx >>= 6;
        }
    }

    public static boolean isValidToken(String token, String validStartChars, String validSubsequentChars) {
        if (token == null || token.length() == 0) {
            return false;
        }
        if (validStartChars.indexOf(token.charAt(0)) == -1) {
            return false;
        }
        for (int i = 1; i < token.length(); ++i) {
            if (validSubsequentChars.indexOf(token.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }
}

