/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.text;

import brooklyn.util.text.NaturalOrderComparator;

public class ComparableVersion
implements Comparable<String> {
    public final String version;

    public ComparableVersion(String version) {
        this.version = version;
    }

    @Override
    public int compareTo(String target) {
        return new NaturalOrderComparator().compare(this.version, target);
    }

    public boolean isGreaterThanOrEqualTo(String target) {
        return this.compareTo(target) >= 0;
    }

    public boolean isGreaterThanAndNotEqualTo(String target) {
        return this.compareTo(target) > 0;
    }

    public boolean isLessThanOrEqualTo(String target) {
        return this.compareTo(target) <= 0;
    }

    public boolean isLessThanAndNotEqualTo(String target) {
        return this.compareTo(target) < 0;
    }

    public boolean isInRange(String lowerBound, String upperBound) {
        return this.isGreaterThanAndNotEqualTo(lowerBound) && this.isLessThanAndNotEqualTo(upperBound);
    }

    public boolean isInRange(String range) {
        boolean strictRight;
        boolean strictLeft;
        String r = range.trim();
        if (r.startsWith("(")) {
            strictLeft = true;
        } else if (r.startsWith("[")) {
            strictLeft = false;
        } else {
            throw new IllegalArgumentException("Range must start with ( or [");
        }
        if (r.endsWith(")")) {
            strictRight = true;
        } else if (r.endsWith("]")) {
            strictRight = false;
        } else {
            throw new IllegalArgumentException("Range must end with ) or ]");
        }
        int i = r.indexOf(",");
        if (i == -1) {
            throw new IllegalArgumentException("Range must contain , following the open bracket and version");
        }
        String left = r.substring(1, i).trim();
        String right = r.substring(i + 1, r.length() - 1).trim();
        if (left.length() > 0) {
            if (strictLeft && this.compareTo(left) <= 0) {
                return false;
            }
            if (!strictLeft && this.compareTo(left) < 0) {
                return false;
            }
        }
        if (right.length() > 0) {
            if (strictRight && this.compareTo(right) >= 0) {
                return false;
            }
            if (!strictRight && this.compareTo(right) > 0) {
                return false;
            }
        }
        return true;
    }
}

