/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.stream;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.stream.KnownSizeInputStream;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Streams {
    private static final Logger log = LoggerFactory.getLogger(Streams.class);

    @Beta
    public static void closeQuietly(Closeable x) {
        block3: {
            try {
                if (x != null) {
                    x.close();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Error closing (ignored) " + x + ": " + e);
            }
        }
    }

    @Deprecated
    public static InputStream fromString(String contents) {
        return Streams.newInputStreamWithContents(contents);
    }

    public static InputStream newInputStreamWithContents(String contents) {
        byte[] bytes = ((String)Preconditions.checkNotNull((Object)contents, (Object)"contents")).getBytes(Charsets.UTF_8);
        return KnownSizeInputStream.of(bytes);
    }

    public static Reader newReaderWithContents(String contents) {
        return new StringReader(contents);
    }

    public static Reader reader(InputStream stream) {
        return new InputStreamReader(stream);
    }

    public static Reader reader(InputStream stream, Charset charset) {
        return new InputStreamReader(stream, charset);
    }

    public static byte[] readFully(InputStream is) {
        try {
            return ByteStreams.toByteArray((InputStream)is);
        }
        catch (IOException ioe) {
            throw Exceptions.propagate(ioe);
        }
    }

    public static String readFullyString(InputStream is) {
        return Streams.readFully(Streams.reader(is));
    }

    public static String readFully(Reader is) {
        try {
            return CharStreams.toString((Readable)is);
        }
        catch (IOException ioe) {
            throw Exceptions.propagate(ioe);
        }
    }

    public static void copy(InputStream input, OutputStream output) {
        try {
            ByteStreams.copy((InputStream)input, (OutputStream)output);
            output.flush();
        }
        catch (IOException ioe) {
            throw Exceptions.propagate(ioe);
        }
    }

    public static void copy(Reader input, Writer output) {
        try {
            CharStreams.copy((Readable)input, (Appendable)output);
            output.flush();
        }
        catch (IOException ioe) {
            throw Exceptions.propagate(ioe);
        }
    }

    public static Supplier<Integer> sizeSupplier(final ByteArrayOutputStream src) {
        Preconditions.checkNotNull((Object)src);
        return new Supplier<Integer>(){

            public Integer get() {
                return src.size();
            }
        };
    }

    public static Function<ByteArrayOutputStream, Integer> sizeFunction() {
        return new Function<ByteArrayOutputStream, Integer>(){

            public Integer apply(ByteArrayOutputStream input) {
                return input.size();
            }
        };
    }

    public static ByteArrayOutputStream byteArrayOfString(String in) {
        return Streams.byteArray(in.getBytes(Charsets.UTF_8));
    }

    public static ByteArrayOutputStream byteArray(byte[] in) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            stream.write(in);
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
        return stream;
    }

    public static boolean logStreamTail(Logger log, String message, ByteArrayOutputStream stream, int max) {
        if (stream != null && stream.size() > 0) {
            String streamS = stream.toString();
            if (max >= 0 && streamS.length() > max) {
                streamS = "... " + streamS.substring(streamS.length() - max);
            }
            log.info(message + ":\n" + streamS);
            return true;
        }
        return false;
    }
}

