/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.stream;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KnownSizeInputStream
extends InputStream {
    private final long length;
    private final InputStream target;

    public static KnownSizeInputStream of(String contents) {
        return KnownSizeInputStream.of(contents.getBytes());
    }

    public static KnownSizeInputStream of(byte[] contents) {
        return new KnownSizeInputStream(new ByteArrayInputStream(contents), contents.length);
    }

    public KnownSizeInputStream(InputStream target, long length) {
        this.target = (InputStream)Preconditions.checkNotNull((Object)target, (Object)"target");
        this.length = length;
    }

    public long length() {
        return this.length;
    }

    public InputStream getTarget() {
        return this.target;
    }

    @Override
    public int read() throws IOException {
        return this.target.read();
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.target.read(b);
    }

    public boolean equals(Object obj) {
        return this.target.equals(obj);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.target.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.target.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.target.available();
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public void close() throws IOException {
        this.target.close();
    }

    @Override
    public void mark(int readlimit) {
        this.target.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.target.reset();
    }

    @Override
    public boolean markSupported() {
        return this.target.markSupported();
    }
}

