/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.ssh;

import brooklyn.util.ssh.BashCommands;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;

public class IptablesCommands {
    @Beta
    public static String iptablesService(String cmd) {
        return BashCommands.sudo(BashCommands.alternatives(BashCommands.ifExecutableElse1("service", "service iptables " + cmd), "/sbin/service iptables " + cmd));
    }

    @Beta
    public static String iptablesServiceStop() {
        return IptablesCommands.iptablesService("stop");
    }

    @Beta
    public static String iptablesServiceStart() {
        return IptablesCommands.iptablesService("start");
    }

    @Beta
    public static String iptablesServiceRestart() {
        return IptablesCommands.iptablesService("restart");
    }

    @Beta
    public static String iptablesServiceStatus() {
        return IptablesCommands.iptablesService("status");
    }

    public static String saveIptablesRules() {
        return BashCommands.alternatives(BashCommands.sudo("service iptables save"), BashCommands.chain(BashCommands.installPackage("iptables-persistent"), BashCommands.sudo("/etc/init.d/iptables-persistent save")));
    }

    public static String cleanUpIptablesRules() {
        return BashCommands.sudo("/sbin/iptables -F");
    }

    public static String listIptablesRule() {
        return BashCommands.sudo("/sbin/iptables -L -v -n");
    }

    public static String insertIptablesRule(Chain chain, brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-I", chain, (Optional<String>)Optional.absent(), protocol, port, policy);
    }

    @Deprecated
    public static String insertIptablesRule(Chain chain, Protocol protocol, int port, Policy policy) {
        return IptablesCommands.insertIptablesRule(chain, protocol.convert(), port, policy);
    }

    public static String insertIptablesRule(Chain chain, String networkInterface, brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-I", chain, (Optional<String>)Optional.of((Object)networkInterface), protocol, port, policy);
    }

    @Deprecated
    public static String insertIptablesRule(Chain chain, String networkInterface, Protocol protocol, int port, Policy policy) {
        return IptablesCommands.insertIptablesRule(chain, networkInterface, protocol.convert(), port, policy);
    }

    public static String appendIptablesRule(Chain chain, brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-A", chain, (Optional<String>)Optional.absent(), protocol, port, policy);
    }

    @Deprecated
    public static String appendIptablesRule(Chain chain, Protocol protocol, int port, Policy policy) {
        return IptablesCommands.appendIptablesRule(chain, protocol.convert(), port, policy);
    }

    public static String appendIptablesRule(Chain chain, String networkInterface, brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule("-A", chain, (Optional<String>)Optional.of((Object)networkInterface), protocol, port, policy);
    }

    @Deprecated
    public static String appendIptablesRule(Chain chain, String networkInterface, Protocol protocol, int port, Policy policy) {
        return IptablesCommands.appendIptablesRule(chain, networkInterface, protocol.convert(), port, policy);
    }

    public static String addIptablesRule(String direction, Chain chain, Optional<String> networkInterface, brooklyn.util.net.Protocol protocol, int port, Policy policy) {
        String addIptablesRule = networkInterface.isPresent() ? String.format("/sbin/iptables %s %s -i %s -p %s --dport %d -j %s", new Object[]{direction, chain, networkInterface.get(), protocol, port, policy}) : String.format("/sbin/iptables %s %s -p %s --dport %d -j %s", new Object[]{direction, chain, protocol, port, policy});
        return BashCommands.sudo(addIptablesRule);
    }

    @Deprecated
    public static String addIptablesRule(String direction, Chain chain, Optional<String> networkInterface, Protocol protocol, int port, Policy policy) {
        return IptablesCommands.addIptablesRule(direction, chain, networkInterface, protocol.convert(), port, policy);
    }

    @Deprecated
    public static enum Protocol {
        TCP("tcp"),
        UDP("udp"),
        ALL("all");

        final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String toString() {
            return this.protocol;
        }

        brooklyn.util.net.Protocol convert() {
            switch (this) {
                case TCP: {
                    return brooklyn.util.net.Protocol.TCP;
                }
                case UDP: {
                    return brooklyn.util.net.Protocol.UDP;
                }
                case ALL: {
                    return brooklyn.util.net.Protocol.ALL;
                }
            }
            throw new IllegalStateException("Unexpected protocol " + (Object)((Object)this));
        }
    }

    public static enum Policy {
        ACCEPT,
        REJECT,
        DROP,
        LOG;

    }

    public static enum Chain {
        INPUT,
        FORWARD,
        OUTPUT;

    }
}

