/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.repeat;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.ReferenceWithError;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Time;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Callables;
import groovy.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Repeater {
    private static final Logger log = LoggerFactory.getLogger(Repeater.class);
    private final String description;
    private Callable<?> body = Callables.returning(null);
    private Callable<Boolean> exitCondition;
    private Function<? super Integer, brooklyn.util.time.Duration> delayOnIteration = null;
    private brooklyn.util.time.Duration timeLimit = null;
    private int iterationLimit = 0;
    private boolean rethrowException = false;
    private boolean rethrowExceptionImmediately = false;
    private boolean warnOnUnRethrownException = true;

    public Repeater() {
        this(null);
    }

    public Repeater(String description) {
        this.description = description != null ? description : "Repeater";
    }

    public static Repeater create() {
        return Repeater.create(null);
    }

    public static Repeater create(String description) {
        return new Repeater(description);
    }

    public Repeater repeat() {
        return this.repeat(Callables.returning(null));
    }

    public Repeater repeat(Runnable body) {
        Preconditions.checkNotNull((Object)body, (Object)"body must not be null");
        this.body = body instanceof Callable ? (Callable<Object>)((Object)body) : Executors.callable(body);
        return this;
    }

    public Repeater repeat(Callable<?> body) {
        Preconditions.checkNotNull(body, (Object)"body must not be null");
        this.body = body;
        return this;
    }

    public Repeater every(long period, TimeUnit unit) {
        return this.every(brooklyn.util.time.Duration.of(period, unit));
    }

    public Repeater every(brooklyn.util.time.Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)"duration must not be null");
        Preconditions.checkArgument((duration.toMilliseconds() > 0L ? 1 : 0) != 0, (String)"period must be positive: %s", (Object[])new Object[]{duration});
        return this.delayOnIteration((Function<? super Integer, brooklyn.util.time.Duration>)Functions.constant((Object)duration));
    }

    public Repeater every(Duration duration) {
        return this.every(brooklyn.util.time.Duration.of(duration));
    }

    public Repeater delayOnIteration(Function<? super Integer, brooklyn.util.time.Duration> delayFunction) {
        Preconditions.checkNotNull(delayFunction, (Object)"delayFunction must not be null");
        this.delayOnIteration = delayFunction;
        return this;
    }

    public Repeater backoff(final brooklyn.util.time.Duration initialDelay, final double multiplier, final @Nullable brooklyn.util.time.Duration finalDelay) {
        Preconditions.checkNotNull((Object)initialDelay, (Object)"initialDelay");
        Preconditions.checkArgument((multiplier >= 1.0 ? 1 : 0) != 0, (Object)"multiplier >= 1.0");
        return this.delayOnIteration((Function<? super Integer, brooklyn.util.time.Duration>)new Function<Integer, brooklyn.util.time.Duration>(){

            public brooklyn.util.time.Duration apply(Integer iteration) {
                brooklyn.util.time.Duration result = initialDelay;
                for (int i = 0; i < iteration; ++i) {
                    result = result.multiply(multiplier);
                    if (finalDelay == null || result.compareTo(finalDelay) <= 0) continue;
                    return finalDelay;
                }
                return result;
            }
        });
    }

    public Repeater backoffTo(brooklyn.util.time.Duration finalDelay) {
        return this.backoff(brooklyn.util.time.Duration.millis(10), 1.2, finalDelay);
    }

    public Repeater until(Callable<Boolean> exitCondition) {
        Preconditions.checkNotNull(exitCondition, (Object)"exitCondition must not be null");
        this.exitCondition = exitCondition;
        return this;
    }

    public <T> Repeater until(final T target, final Predicate<T> exitCondition) {
        Preconditions.checkNotNull(exitCondition, (Object)"exitCondition must not be null");
        return this.until(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return exitCondition.apply(target);
            }
        });
    }

    public Repeater rethrowException() {
        this.rethrowException = true;
        return this;
    }

    public Repeater rethrowExceptionImmediately() {
        this.rethrowExceptionImmediately = true;
        return this;
    }

    public Repeater suppressWarnings() {
        this.warnOnUnRethrownException = false;
        return this;
    }

    public Repeater limitIterationsTo(int iterationLimit) {
        Preconditions.checkArgument((iterationLimit > 0 ? 1 : 0) != 0, (String)"iterationLimit must be positive: %s", (Object[])new Object[]{iterationLimit});
        this.iterationLimit = iterationLimit;
        return this;
    }

    public Repeater limitTimeTo(long deadline, TimeUnit unit) {
        return this.limitTimeTo(brooklyn.util.time.Duration.of(deadline, unit));
    }

    public Repeater limitTimeTo(brooklyn.util.time.Duration duration) {
        Preconditions.checkNotNull((Object)duration, (Object)"duration must not be null");
        Preconditions.checkArgument((duration.toMilliseconds() > 0L ? 1 : 0) != 0, (String)"deadline must be positive: %s", (Object[])new Object[]{duration});
        this.timeLimit = duration;
        return this;
    }

    public boolean run() {
        return this.runKeepingError().getWithoutError();
    }

    public void runRequiringTrue() {
        Stopwatch timer = Stopwatch.createStarted();
        ReferenceWithError<Boolean> result = this.runKeepingError();
        result.checkNoError();
        if (!result.get().booleanValue()) {
            throw new IllegalStateException(this.description + " unsatisfied after " + brooklyn.util.time.Duration.of(timer));
        }
    }

    public ReferenceWithError<Boolean> runKeepingError() {
        Preconditions.checkState((this.body != null ? 1 : 0) != 0, (Object)"repeat() method has not been called to set the body");
        Preconditions.checkState((this.exitCondition != null ? 1 : 0) != 0, (Object)"until() method has not been called to set the exit condition");
        Preconditions.checkState((this.delayOnIteration != null ? 1 : 0) != 0, (Object)"every() method (or other delaySupplier() / backoff() method) has not been called to set the loop delay");
        Exception lastError = null;
        int iterations = 0;
        CountdownTimer timer = this.timeLimit != null ? CountdownTimer.newInstanceStarted(this.timeLimit) : CountdownTimer.newInstancePaused(brooklyn.util.time.Duration.PRACTICALLY_FOREVER);
        while (true) {
            boolean done;
            brooklyn.util.time.Duration delayThisIteration;
            block19: {
                block18: {
                    delayThisIteration = (brooklyn.util.time.Duration)this.delayOnIteration.apply((Object)iterations);
                    ++iterations;
                    try {
                        this.body.call();
                    }
                    catch (Exception e) {
                        log.warn(this.description, (Throwable)e);
                        if (!this.rethrowExceptionImmediately) break block18;
                        throw Exceptions.propagate(e);
                    }
                }
                done = false;
                try {
                    lastError = null;
                    done = this.exitCondition.call();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug(this.description, (Throwable)e);
                    }
                    lastError = e;
                    if (!this.rethrowExceptionImmediately) break block19;
                    throw Exceptions.propagate(e);
                }
            }
            if (done) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: condition satisfied", (Object)this.description);
                }
                return ReferenceWithError.newInstanceWithoutError(true);
            }
            if (log.isDebugEnabled()) {
                String msg = String.format("%s: unsatisfied during iteration %s %s", this.description, iterations, (this.iterationLimit > 0 ? "(max " + this.iterationLimit + " attempts)" : "") + (timer.isRunning() ? "(" + Time.makeTimeStringRounded(timer.getDurationRemaining()) + " remaining)" : ""));
                if (iterations == 1) {
                    log.debug(msg);
                } else {
                    log.trace(msg);
                }
            }
            if (this.iterationLimit > 0 && iterations >= this.iterationLimit) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: condition not satisfied and exceeded iteration limit", (Object)this.description);
                }
                if (this.rethrowException && lastError != null) {
                    log.warn("{}: error caught checking condition (rethrowing): {}", (Object)this.description, (Object)lastError.getMessage());
                    throw Exceptions.propagate(lastError);
                }
                if (this.warnOnUnRethrownException && lastError != null) {
                    log.warn("{}: error caught checking condition: {}", (Object)this.description, (Object)lastError.getMessage());
                }
                return ReferenceWithError.newInstanceMaskingError(false, lastError);
            }
            if (timer.isExpired()) {
                if (log.isDebugEnabled()) {
                    log.debug("{}: condition not satisfied, with {} elapsed (limit {})", new Object[]{this.description, Time.makeTimeStringRounded(timer.getDurationElapsed()), Time.makeTimeStringRounded(this.timeLimit)});
                }
                if (this.rethrowException && lastError != null) {
                    log.error("{}: error caught checking condition: {}", (Object)this.description, (Object)lastError.getMessage());
                    throw Exceptions.propagate(lastError);
                }
                return ReferenceWithError.newInstanceMaskingError(false, lastError);
            }
            Time.sleep(delayThisIteration);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public brooklyn.util.time.Duration getTimeLimit() {
        return this.timeLimit;
    }
}

