/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.pool;

import brooklyn.util.pool.Lease;
import brooklyn.util.pool.Pool;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.Identifiers;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPool<T>
implements Pool<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicPool.class);
    private final String name;
    private final Supplier<? extends T> supplier;
    private final Predicate<? super T> viabilityChecker;
    private Function<? super T, ?> closer;
    private final Deque<T> pool = Lists.newLinkedList();
    private AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicInteger currentLeasedCount = new AtomicInteger(0);
    private AtomicInteger totalLeasedCount = new AtomicInteger(0);
    private AtomicInteger totalCreatedCount = new AtomicInteger(0);
    private AtomicInteger totalClosedCount = new AtomicInteger(0);

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private BasicPool(Builder<T> builder) {
        this.name = ((Builder)builder).name != null ? "Pool(" + ((Builder)builder).name + ")" : "Pool-" + Identifiers.makeRandomId(8);
        this.supplier = (Supplier)Preconditions.checkNotNull((Object)((Builder)builder).supplier, (Object)"supplier");
        this.viabilityChecker = (Predicate)Preconditions.checkNotNull((Object)((Builder)builder).viabilityChecker, (Object)"viabilityChecker");
        this.closer = (Function)Preconditions.checkNotNull((Object)((Builder)builder).closer, this.closer);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Lease<T> leaseObject() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R exec(Function<? super T, R> receiver) {
        Lease<T> lease = this.leaseObject();
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} executing {} with leasee {}", new Object[]{this, receiver, lease.leasedObject()});
            }
            Object object = receiver.apply(lease.leasedObject());
            return (R)object;
        }
        finally {
            Streams.closeQuietly(lease);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Deque<T> deque = this.pool;
        synchronized (deque) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} closing, with {} resources ({})", new Object[]{this, this.pool.size(), this.getMetrics()});
            }
            this.closed.set(true);
            for (T resource : this.pool) {
                this.totalClosedCount.incrementAndGet();
                this.closer.apply(resource);
            }
            this.pool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnLeasee(T val) {
        this.currentLeasedCount.decrementAndGet();
        Deque<T> deque = this.pool;
        synchronized (deque) {
            if (this.closed.get()) {
                this.totalClosedCount.incrementAndGet();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} closing returned leasee {}, because pool closed ({})", new Object[]{this, val, this.getMetrics()});
                }
                this.closer.apply(val);
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{} adding {} back into pool ({})", new Object[]{this, val, this.getMetrics()});
                }
                this.pool.addLast(val);
            }
        }
    }

    private String getMetrics() {
        return String.format("currentLeased=%s; totalLeased=%s; totalCreated=%s; totalClosed=%s", this.currentLeasedCount, this.totalLeasedCount, this.totalCreatedCount, this.totalClosedCount);
    }

    private class BasicLease
    implements Lease<T> {
        private final T val;

        BasicLease(T val) {
            this.val = val;
        }

        @Override
        public T leasedObject() {
            return this.val;
        }

        @Override
        public void close() {
            BasicPool.this.returnLeasee(this.val);
        }
    }

    public static class Builder<T> {
        private String name;
        private Supplier<? extends T> supplier;
        private Predicate<? super T> viabilityChecker = Predicates.alwaysTrue();
        private Function<? super T, ?> closer = Functions.identity();

        public Builder<T> name(String val) {
            this.name = val;
            return this;
        }

        public Builder<T> supplier(Supplier<? extends T> val) {
            this.supplier = val;
            return this;
        }

        public Builder<T> viabilityChecker(Predicate<? super T> val) {
            this.viabilityChecker = val;
            return this;
        }

        public Builder<T> closer(Function<? super T, ?> val) {
            this.closer = val;
            return this;
        }

        public BasicPool<T> build() {
            return new BasicPool(this);
        }
    }
}

