/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.net;

import com.google.common.base.Objects;
import com.google.common.net.HostAndPort;
import java.io.Serializable;

public class UserAndHostAndPort
implements Serializable {
    private static final long serialVersionUID = 1525306419968853853L;
    private final String user;
    private final HostAndPort hostAndPort;

    public static UserAndHostAndPort fromParts(String user, String host, int port) {
        return new UserAndHostAndPort(user, HostAndPort.fromParts((String)host, (int)port));
    }

    public static UserAndHostAndPort fromString(String str) {
        int userEnd = str.indexOf("@");
        if (userEnd < 0) {
            throw new IllegalArgumentException("User missing (no '@' in " + str);
        }
        return new UserAndHostAndPort(str.substring(0, userEnd).trim(), HostAndPort.fromString((String)str.substring(userEnd + 1).trim()));
    }

    protected UserAndHostAndPort(String user, HostAndPort hostAndPort) {
        this.user = user;
        this.hostAndPort = hostAndPort;
    }

    public String getUser() {
        return this.user;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public String toString() {
        return this.user + "@" + this.hostAndPort.getHostText() + (this.hostAndPort.hasPort() ? ":" + this.hostAndPort.getPort() : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UserAndHostAndPort)) {
            return false;
        }
        UserAndHostAndPort o = (UserAndHostAndPort)obj;
        return Objects.equal((Object)this.user, (Object)o.user) && Objects.equal((Object)this.hostAndPort, (Object)o.hostAndPort);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.user, this.hostAndPort});
    }
}

