/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.net;

import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import com.google.common.net.MediaType;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class Urls {
    public static Function<String, URI> stringToUriFunction() {
        return StringToUri.INSTANCE;
    }

    public static Function<String, URL> stringToUrlFunction() {
        return StringToUrl.INSTANCE;
    }

    public static final URL toUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static final URL toUrl(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static final URI toUri(@Nullable String uri) {
        if (uri == null) {
            return null;
        }
        return URI.create(uri);
    }

    public static final URI toUri(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static boolean isUrlWithProtocol(String x) {
        if (x == null) {
            return false;
        }
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (c == ':') {
                return i > 0;
            }
            if (Character.isLetter(c)) continue;
            return false;
        }
        return false;
    }

    public static String mergePaths(String ... items) {
        List<String> parts = Arrays.asList(items);
        if (parts.contains(null)) {
            throw new NullPointerException(String.format("Unable to reliably merge path from parts: %s; input contains null values", parts));
        }
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            boolean trimThisMerge;
            boolean bl = trimThisMerge = result.length() > 0 && !result.toString().endsWith("://") && !result.toString().endsWith(":///") && !result.toString().endsWith(":");
            if (trimThisMerge) {
                while (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
                    result.deleteCharAt(result.length() - 1);
                }
                result.append('/');
            }
            int i = result.length();
            result.append(part);
            if (!trimThisMerge) continue;
            while (result.length() > i && result.charAt(i) == '/') {
                result.deleteCharAt(i);
            }
        }
        return result.toString();
    }

    public static String encode(String text) {
        return URLEncoder.encode(text);
    }

    public static String decode(String text) {
        return URLDecoder.decode(text);
    }

    public static String getProtocol(String url) {
        if (url == null) {
            return null;
        }
        int i = 0;
        StringBuilder result = new StringBuilder();
        while (url.length() > i) {
            char c = url.charAt(i);
            if (!Character.isLetter(c)) {
                if (c == ':') {
                    if (i >= 2) {
                        return result.toString().toLowerCase();
                    }
                    return null;
                }
                return null;
            }
            result.append(c);
            ++i;
        }
        return null;
    }

    public static String getBasename(String url) {
        int firstQ;
        if (url == null) {
            return null;
        }
        if (Urls.getProtocol(url) != null && (firstQ = url.indexOf(63)) >= 0) {
            url = url.substring(0, firstQ);
        }
        url = Strings.removeAllFromEnd(url, "/");
        return url.substring(url.lastIndexOf(47) + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDirectory(String fileUrl) {
        File file;
        if (Urls.isUrlWithProtocol(fileUrl)) {
            if (!Urls.getProtocol(fileUrl).equals("file")) return false;
            file = new File(URI.create(fileUrl));
            return file.isDirectory();
        } else {
            file = new File(fileUrl);
        }
        return file.isDirectory();
    }

    public static File toFile(String fileUrl) {
        if (Urls.isUrlWithProtocol(fileUrl)) {
            if (Urls.getProtocol(fileUrl).equals("file")) {
                return new File(URI.create(fileUrl));
            }
            throw new IllegalArgumentException("Not a file protocol URL: " + fileUrl);
        }
        return new File(fileUrl);
    }

    public static String asDataUrlBase64(String data) {
        return Urls.asDataUrlBase64(MediaType.PLAIN_TEXT_UTF_8, data.getBytes());
    }

    public static String asDataUrlBase64(MediaType type, byte[] bytes) {
        return "data:" + (type != null ? type.withoutParameters().toString() : "") + ";base64," + new String(BaseEncoding.base64().encode(bytes));
    }

    private static enum StringToUrl implements Function<String, URL>
    {
        INSTANCE;


        public URL apply(@Nullable String input) {
            return Urls.toUrl(input);
        }

        public String toString() {
            return "StringToUrl";
        }
    }

    private static enum StringToUri implements Function<String, URI>
    {
        INSTANCE;


        public URI apply(@Nullable String input) {
            return Urls.toUri(input);
        }

        public String toString() {
            return "StringToUri";
        }
    }
}

