/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.maven;

import brooklyn.util.collections.MutableList;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenArtifact {
    private static final Logger log = LoggerFactory.getLogger(MavenArtifact.class);
    @Nonnull
    protected final String groupId;
    @Nonnull
    protected final String artifactId;
    @Nonnull
    protected final String packaging;
    @Nullable
    protected final String classifier;
    @Nonnull
    protected final String version;
    @Nullable
    protected String customFileNameAfterArtifactMarker;
    @Nullable
    protected String classifierFileNameMarker;

    public MavenArtifact(String groupId, String artifactId, String packaging, String classifier, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packaging = packaging;
        this.classifier = classifier;
        this.version = version;
    }

    public MavenArtifact(String groupId, String artifactId, String packaging, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packaging = packaging;
        this.classifier = null;
        this.version = version;
    }

    public static MavenArtifact fromCoordinate(String coordinate) {
        String[] parts = ((String)Preconditions.checkNotNull((Object)coordinate, (Object)"coordinate")).split(":");
        if (parts.length == 4) {
            return new MavenArtifact(parts[0], parts[1], parts[2], parts[3]);
        }
        if (parts.length == 5) {
            return new MavenArtifact(parts[0], parts[1], parts[2], parts[3], parts[4]);
        }
        throw new IllegalArgumentException("Invalid maven coordinate '" + coordinate + "'");
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public boolean isSnapshot() {
        return this.getVersion().toUpperCase().contains("SNAPSHOT");
    }

    public String getCustomFileNameAfterArtifactMarker() {
        return this.customFileNameAfterArtifactMarker;
    }

    public void setCustomFileNameAfterArtifactMarker(String customFileNameMarker) {
        this.customFileNameAfterArtifactMarker = customFileNameMarker;
    }

    public String getClassifierFileNameMarker() {
        return this.classifierFileNameMarker != null ? this.classifierFileNameMarker : this.getClassifier();
    }

    public void setClassifierFileNameMarker(String classifierFileNameMarker) {
        this.classifierFileNameMarker = classifierFileNameMarker;
    }

    public String getCoordinate() {
        return Strings.join(MutableList.of().append(this.groupId, this.artifactId, this.packaging).appendIfNotNull(this.classifier).append(this.version), ":");
    }

    public String getFilename() {
        return this.artifactId + "-" + (Strings.isNonEmpty(this.getCustomFileNameAfterArtifactMarker()) ? this.getCustomFileNameAfterArtifactMarker() + "-" : "") + this.version + (Strings.isNonEmpty(this.getClassifierFileNameMarker()) ? "-" + this.getClassifierFileNameMarker() : "") + (Strings.isNonEmpty(this.getExtension()) ? "." + this.getExtension() : "");
    }

    @Nullable
    public String getExtension() {
        if ("jar".equalsIgnoreCase(this.packaging) || "bundle".equalsIgnoreCase(this.packaging)) {
            return "jar";
        }
        if ("war".equalsIgnoreCase(this.packaging)) {
            return "war";
        }
        log.debug("Unrecognised packaging for autodetecting extension, defaulting to {} for: {}", (Object)this.packaging, (Object)this);
        return this.packaging;
    }

    public String toString() {
        return JavaClassNames.simpleClassName(this) + "[" + this.getCoordinate() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.classifierFileNameMarker == null ? 0 : this.classifierFileNameMarker.hashCode());
        result = 31 * result + (this.customFileNameAfterArtifactMarker == null ? 0 : this.customFileNameAfterArtifactMarker.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.packaging == null ? 0 : this.packaging.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifact other = (MavenArtifact)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.classifierFileNameMarker == null ? other.classifierFileNameMarker != null : !this.classifierFileNameMarker.equals(other.classifierFileNameMarker)) {
            return false;
        }
        if (this.customFileNameAfterArtifactMarker == null ? other.customFileNameAfterArtifactMarker != null : !this.customFileNameAfterArtifactMarker.equals(other.customFileNameAfterArtifactMarker)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.packaging == null ? other.packaging != null : !this.packaging.equals(other.packaging)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

