/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.math;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public class MathPredicates {
    public static <T extends Number> Predicate<T> greaterThan(final double val) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return input == null ? false : ((Number)input).doubleValue() > val;
            }
        };
    }

    public static <T extends Number> Predicate<T> greaterThanOrEqual(final double val) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return input == null ? false : ((Number)input).doubleValue() >= val;
            }
        };
    }

    public static <T extends Number> Predicate<T> lessThan(final double val) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return input == null ? false : ((Number)input).doubleValue() < val;
            }
        };
    }

    public static <T extends Number> Predicate<T> lessThanOrEqual(final double val) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                return input == null ? false : ((Number)input).doubleValue() <= val;
            }
        };
    }

    public static <T extends Number> Predicate<T> equalsApproximately(Number val, double delta) {
        return new EqualsApproximately(val, delta);
    }

    public static <T extends Number> Predicate<T> equalsApproximately(Number val) {
        return MathPredicates.equalsApproximately(val, 1.0E-7);
    }

    private static final class EqualsApproximately<T extends Number>
    implements Predicate<T> {
        private final double val;
        private final double delta;

        private EqualsApproximately(Number val, double delta) {
            this.val = val.doubleValue();
            Preconditions.checkArgument((delta >= 0.0 ? 1 : 0) != 0, (Object)"delta must be non-negative");
            this.delta = delta;
        }

        public boolean apply(@Nullable T input) {
            return input == null ? false : Math.abs(((Number)input).doubleValue() - this.val) <= this.delta;
        }

        public String toString() {
            return "equals-approximately(" + this.val + " +- " + this.delta + ")";
        }
    }
}

