/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.math;

import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import javax.annotation.Nullable;

public class MathFunctions {
    public static Function<Number, Integer> plus(final int addend) {
        return new Function<Number, Integer>(){

            public Integer apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.intValue() + addend;
            }
        };
    }

    public static Function<Number, Long> plus(final long addend) {
        return new Function<Number, Long>(){

            public Long apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.longValue() + addend;
            }
        };
    }

    public static Function<Number, Double> plus(final double addend) {
        return new Function<Number, Double>(){

            public Double apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.doubleValue() + addend;
            }
        };
    }

    public static Function<Number, Integer> times(final int multiplicand) {
        return new Function<Number, Integer>(){

            public Integer apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.intValue() * multiplicand;
            }
        };
    }

    public static Function<Number, Long> times(final long multiplicand) {
        return new Function<Number, Long>(){

            public Long apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.longValue() * multiplicand;
            }
        };
    }

    public static Function<Number, Double> times(final double multiplicand) {
        return new Function<Number, Double>(){

            public Double apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.doubleValue() * multiplicand;
            }
        };
    }

    public static Function<Number, Double> divide(final double divisor) {
        return new Function<Number, Double>(){

            public Double apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return input.doubleValue() / divisor;
            }
        };
    }

    public static <T> Function<T, Double> divide(final Function<T, ? extends Number> input, final double divisor) {
        return new Function<T, Double>(){

            public Double apply(@Nullable T input2) {
                if (input == null) {
                    return null;
                }
                Number n = (Number)input.apply(input2);
                if (n == null) {
                    return null;
                }
                return n.doubleValue() / divisor;
            }
        };
    }

    public static Function<Number, String> readableString(final int significantDigits, final int maxLen) {
        return new Function<Number, String>(){

            public String apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return Strings.makeRealString(input.doubleValue(), maxLen, significantDigits, 0);
            }
        };
    }

    public static Function<Number, String> percent(final int significantDigits) {
        return new Function<Number, String>(){

            public String apply(@Nullable Number input) {
                if (input == null) {
                    return null;
                }
                return (String)MathFunctions.readableString(significantDigits, significantDigits + 3).apply((Object)(input.doubleValue() * 100.0)) + "%";
            }
        };
    }
}

