/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.math;

public class BitUtils {
    public static byte reverseBitSignificance(byte b) {
        int result = 0;
        for (int i = 0; i < 8; ++i) {
            result <<= 1;
            if ((b & 1) == 1) {
                ++result;
            }
            b = (byte)(b >> 1);
        }
        return (byte)result;
    }

    public static byte reverseBitSignificanceInByte(int b) {
        return BitUtils.reverseBitSignificance((byte)b);
    }

    public static byte[] reverseBitSignificance(byte ... bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = BitUtils.reverseBitSignificance(bytes[i]);
        }
        return result;
    }

    public static byte[] reverseBitSignificanceInBytes(int ... bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = BitUtils.reverseBitSignificance((byte)bytes[i]);
        }
        return result;
    }

    public static int unsigned(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    public static int unsignedByte(int b) {
        if (b < 0) {
            return b % 256 + 256;
        }
        return b % 256;
    }
}

