/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.math;

import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;

public class BitList {
    private final BitSet bits;
    protected final int length;

    protected BitList(BitSet bits, int length) {
        assert (length >= bits.length());
        this.bits = bits;
        this.length = length;
    }

    public static BitList newInstance(BitSet bits, int length) {
        return new BitList(bits, length);
    }

    public int length() {
        return this.length;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Index " + index + " in " + this);
        }
        return this.bits.get(index);
    }

    public static BitList newInstance(byte ... bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[i / 8] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return BitList.newInstance(bits, bytes.length * 8);
    }

    public static BitList newInstanceFromBytes(int ... bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[i / 8] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return BitList.newInstance(bits, bytes.length * 8);
    }

    public static BitList newInstance(List<Boolean> l) {
        BitSet bs = new BitSet();
        for (int i = 0; i < l.size(); ++i) {
            bs.set(i, l.get(i));
        }
        return new BitList(bs, l.size());
    }

    public static BitList newInstance(boolean ... l) {
        BitSet bs = new BitSet();
        for (int i = 0; i < l.length; ++i) {
            bs.set(i, l[i]);
        }
        return new BitList(bs, l.length);
    }

    public static BitList newInstance(BigInteger x) {
        BitSet bs = new BitSet();
        for (int i = 0; i < x.bitLength(); ++i) {
            if (!x.testBit(i)) continue;
            bs.set(i);
        }
        return new BitList(bs, x.bitLength());
    }

    public byte[] asBytes() {
        byte[] bytes = new byte[(this.length + 7) / 8];
        for (int i = 0; i < this.bits.length(); ++i) {
            if (!this.bits.get(i)) continue;
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public int[] asUnsignedBytes() {
        int[] bytes = new int[(this.length + 7) / 8];
        for (int i = 0; i < this.bits.length(); ++i) {
            if (!this.bits.get(i)) continue;
            int n = i / 8;
            bytes[n] = bytes[n] | 1 << i % 8;
        }
        return bytes;
    }

    public BitSet asBitSet() {
        return (BitSet)this.bits.clone();
    }

    public List<Boolean> asList() {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (int i = 0; i < this.length(); ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public BitList orred(BitList other) {
        BitSet result = this.asBitSet();
        result.or(other.asBitSet());
        return new BitList(result, Math.max(this.length, other.length));
    }

    public BitList anded(BitList other) {
        BitSet result = this.asBitSet();
        result.and(other.asBitSet());
        return new BitList(result, Math.max(this.length, other.length));
    }

    public BitList xorred(BitList other) {
        BitSet result = this.asBitSet();
        result.xor(other.asBitSet());
        return new BitList(result, Math.max(this.length, other.length));
    }

    public BitList notted() {
        BitSet result = this.asBitSet();
        result.flip(0, this.length);
        return new BitList(result, this.length);
    }

    public BitList resized(int length) {
        BitSet b2 = this.asBitSet();
        if (b2.length() > length) {
            b2.clear(length, b2.length());
        }
        return BitList.newInstance(b2, length);
    }

    public BitList reversed() {
        BitSet b = new BitSet();
        int from = this.bits.length() - 1;
        int to = this.length - this.bits.length();
        while (from >= 0) {
            if (this.get(from)) {
                b.set(to);
            }
            --from;
            ++to;
        }
        return new BitList(b, this.length);
    }

    public int commonPrefixLength(BitList other) {
        int i;
        for (i = 0; i < this.length && i < other.length; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return i;
        }
        return i;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean isZero() {
        return this.bits.cardinality() == 0;
    }

    public BigInteger asBigInteger() {
        if (this.length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(Bytes.toArray((Collection)Lists.reverse(this.asByteList())));
    }

    public boolean[] asArray() {
        boolean[] result = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public List<Byte> asByteList() {
        return Bytes.asList((byte[])this.asBytes());
    }

    public byte byteValue() {
        return this.asBigInteger().byteValue();
    }

    public int intValue() {
        return this.asBigInteger().intValue();
    }

    public long longValue() {
        return this.asBigInteger().longValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bits == null ? 0 : this.bits.hashCode());
        result = 31 * result + this.length;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitList other = (BitList)obj;
        if (this.bits == null ? other.bits != null : !this.bits.equals(other.bits)) {
            return false;
        }
        return this.length == other.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            if (i % 8 == 0 && i > 0) {
                sb.append(":");
            }
            sb.append(this.get(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }
}

