/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.logging;

import com.google.common.base.Throwables;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SimpleOneLineLogFormatter
extends Formatter {
    public final boolean showLevel;
    public final boolean showThread;
    public final boolean showCaller;
    protected final Date date = new Date();
    protected DateFormat dateFormat = new SimpleDateFormat(this.getDateFormat());

    public SimpleOneLineLogFormatter() {
        this(true, false, false);
    }

    public SimpleOneLineLogFormatter(boolean showLevel, boolean showThread, boolean showCaller) {
        this.showLevel = showLevel;
        this.showThread = showThread;
        this.showCaller = showCaller;
    }

    public String getDateFormat() {
        return "yyyy-MM-dd HH:mm:ss.SSSZ";
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.appendDate(record, sb);
        this.appendLevel(record, sb);
        sb.append("  ");
        sb.append(this.formatMessage(record));
        this.appendThreadAndCaller(record, sb);
        this.appendDetailsWithNewLine(sb, record);
        return sb.toString();
    }

    protected void appendLevel(LogRecord record, StringBuffer sb) {
        if (this.showLevel) {
            sb.append(" [").append(record.getLevel()).append("]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendDate(LogRecord record, StringBuffer sb) {
        Date date = this.date;
        synchronized (date) {
            this.date.setTime(record.getMillis());
            sb.append(this.dateFormat.format(this.date));
        }
    }

    protected void appendThreadAndCaller(LogRecord record, StringBuffer sb) {
        if (this.showThread || this.showCaller) {
            sb.append(" [");
            if (this.showThread) {
                sb.append(this.getThreadName(record));
            }
            if (this.showThread && this.showCaller) {
                sb.append(", ");
            }
            if (this.showCaller) {
                if (record.getSourceClassName() != null) {
                    sb.append(record.getSourceClassName());
                } else {
                    sb.append(record.getLoggerName());
                }
                if (record.getSourceMethodName() != null) {
                    sb.append(" ");
                    sb.append(record.getSourceMethodName());
                }
            }
            sb.append("]");
        }
    }

    protected void appendDetailsWithNewLine(StringBuffer sb, LogRecord record) {
        if (record.getThrown() != null) {
            try {
                sb.append('\n');
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        } else {
            sb.append('\n');
        }
    }

    protected String getThreadName(LogRecord record) {
        LogRecord lr = new LogRecord(Level.INFO, "");
        if (lr.getThreadID() == record.getThreadID()) {
            return Thread.currentThread().getName() + " (" + record.getThreadID() + ")";
        }
        return "thread (" + record.getThreadID() + ")";
    }

    public static class LogFormatterWithThreadAndCaller
    extends SimpleOneLineLogFormatter {
        public LogFormatterWithThreadAndCaller() {
            super(true, true, true);
        }
    }
}

