/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.javalang;

import brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Threads {
    private static final Logger log = LoggerFactory.getLogger(Threads.class);

    public static Thread addShutdownHook(final Runnable task) {
        Thread t = new Thread("shutdownHookThread"){

            @Override
            public void run() {
                try {
                    task.run();
                }
                catch (Exception e) {
                    log.error("Failed to execute shutdownhook", (Throwable)e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(t);
        return t;
    }

    public static boolean removeShutdownHook(Thread hook) {
        try {
            return Runtime.getRuntime().removeShutdownHook(hook);
        }
        catch (IllegalStateException e) {
            String text = Exceptions.collapseText(e);
            if (text.contains("Shutdown in progress")) {
                if (log.isTraceEnabled()) {
                    log.trace("Could not remove shutdown hook " + hook + ": " + text);
                }
            } else {
                log.warn("Could not remove shutdown hook " + hook + ": " + text);
                log.debug("Shutdown hook removal details: " + e, (Throwable)e);
            }
            return false;
        }
    }
}

