/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.javalang;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryUsageTracker {
    public static final MemoryUsageTracker SOFT_REFERENCES = new MemoryUsageTracker();
    AtomicLong bytesUsed = new AtomicLong(0L);
    Cache<Object, Long> memoryTrackedReferences = CacheBuilder.newBuilder().weakKeys().removalListener((RemovalListener)new RemovalListener<Object, Long>(){

        public void onRemoval(RemovalNotification<Object, Long> notification) {
            MemoryUsageTracker.this.bytesUsed.addAndGet(-((Long)notification.getValue()).longValue());
        }
    }).build();

    public void track(Object instance, long bytesUsedByInstance) {
        this.bytesUsed.addAndGet(bytesUsedByInstance);
        this.memoryTrackedReferences.put(instance, (Object)bytesUsedByInstance);
    }

    public long getBytesUsed() {
        this.memoryTrackedReferences.cleanUp();
        return this.bytesUsed.get();
    }
}

