/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.javalang;

import brooklyn.util.javalang.StackTraceSimplifier;
import brooklyn.util.net.Urls;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;

public class JavaClassNames {
    private static final StackTraceSimplifier STACK_TRACE_SIMPLIFIER_EXCLUDING_UTIL_JAVALANG = StackTraceSimplifier.newInstance(StackTraceSimplifier.class.getPackage().getName() + ".");

    public static Class<?> type(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Class) {
            return (Class)x;
        }
        if (x instanceof TypeToken) {
            return ((TypeToken)x).getRawType();
        }
        return x.getClass();
    }

    public static Class<?> componentType(Object x) {
        Class<?> c = JavaClassNames.type(x);
        if (c == null) {
            return null;
        }
        while (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    public static String simpleClassName(Class<?> t) {
        int arrayCount = 0;
        while (t.isArray()) {
            ++arrayCount;
            t = t.getComponentType();
        }
        Class<?> ct = JavaClassNames.componentType(t);
        String result = ct.getSimpleName();
        if ((Strings.isBlank(result) || result.length() <= 4) && !ct.isPrimitive()) {
            result = ct.getName();
        }
        return result + Strings.repeat("[]", arrayCount);
    }

    public static String simpleClassName(Object x) {
        if (x == null) {
            return null;
        }
        return JavaClassNames.simpleClassName(JavaClassNames.type(x));
    }

    public static String simplifyClassName(String className) {
        if (className == null) {
            return null;
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot < className.length() - 5) {
            return className.substring(lastDot + 1);
        }
        return className;
    }

    public static String cleanSimpleClassName(Object x) {
        return Strings.makeValidFilename(JavaClassNames.simpleClassName(x));
    }

    public static String cleanSimpleClassName(Class<?> x) {
        return Strings.makeValidFilename(JavaClassNames.simpleClassName(x));
    }

    public static String packageName(Object x) {
        return JavaClassNames.componentType(x).getPackage().getName();
    }

    public static String packagePath(Object x) {
        return Urls.mergePaths("/", JavaClassNames.componentType(x).getPackage().getName().replace('.', '/'), "/");
    }

    public static String resolveName(Object context, String path) {
        Preconditions.checkNotNull((Object)path, (Object)"path must not be null");
        if (path.startsWith("/") || Urls.isUrlWithProtocol(path)) {
            return path;
        }
        Preconditions.checkNotNull((Object)context, (Object)"context must not be null when path is relative");
        return JavaClassNames.packagePath(context) + path;
    }

    public static String resolveClasspathUrl(Object context, String path) {
        if (Urls.isUrlWithProtocol(path)) {
            return path;
        }
        return "classpath:/" + JavaClassNames.resolveName(context, path);
    }

    public static StackTraceElement[] currentStackTraceCleaned() {
        return STACK_TRACE_SIMPLIFIER_EXCLUDING_UTIL_JAVALANG.clean(Thread.currentThread().getStackTrace());
    }

    public static StackTraceElement currentStackElement() {
        return STACK_TRACE_SIMPLIFIER_EXCLUDING_UTIL_JAVALANG.nthUseful(0, Thread.currentThread().getStackTrace());
    }

    public static StackTraceElement callerStackElement(int depth) {
        return STACK_TRACE_SIMPLIFIER_EXCLUDING_UTIL_JAVALANG.nthUseful(depth, Thread.currentThread().getStackTrace());
    }

    public static String niceClassAndMethod(StackTraceElement st) {
        return JavaClassNames.simplifyClassName(st.getClassName()) + "." + st.getMethodName();
    }

    public static String callerNiceClassAndMethod(int depth) {
        return JavaClassNames.niceClassAndMethod(JavaClassNames.callerStackElement(depth));
    }

    public static String niceClassAndMethod() {
        return JavaClassNames.callerNiceClassAndMethod(0);
    }
}

