/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.javalang;

import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.text.StringFunctions;
import brooklyn.util.text.Strings;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Arrays;

public class Enums {
    @Deprecated
    public static Function<Enum<?>, String> enumValueNameFunction() {
        return new Function<Enum<?>, String>(){

            public String apply(Enum<?> input) {
                return input.name();
            }
        };
    }

    public static Function<Enum<?>, String> nameFunction() {
        return new EnumToNameFunction();
    }

    public static <T extends Enum<?>> Function<String, T> fromStringFunction(Class<T> type) {
        return new EnumFromStringFunction<T>(type);
    }

    private static <T extends Enum<?>> T[] values(Class<T> type) {
        try {
            return (Enum[])type.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public static void checkAllEnumeratedIgnoreCase(Class<? extends Enum<?>> type, String ... explicitValues) {
        Enums.checkAllEnumeratedIgnoreCase(JavaClassNames.simpleClassName(type), Enums.values(type), explicitValues);
    }

    public static void checkAllEnumeratedIgnoreCase(String contextMessage, Enum<?>[] enumValues, String ... explicitValues) {
        MutableSet explicitValuesSet = MutableSet.copyOf(Iterables.transform(Arrays.asList(explicitValues), StringFunctions.toLowerCase()));
        MutableSet missingEnums = MutableSet.of();
        for (Enum<?> e : enumValues) {
            if (explicitValuesSet.remove(e.name().toLowerCase()) || explicitValuesSet.remove(e.toString().toLowerCase()) || explicitValuesSet.remove(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, e.name()).toLowerCase()) || explicitValuesSet.remove(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, e.toString()).toLowerCase()) || explicitValuesSet.remove(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, e.toString()).toLowerCase()) || explicitValuesSet.remove(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, e.name()).toLowerCase())) continue;
            missingEnums.add(e);
        }
        if (!missingEnums.isEmpty() || !explicitValuesSet.isEmpty()) {
            throw new IllegalStateException("Not all options for " + contextMessage + " are enumerated; " + "leftover enums = " + missingEnums + "; " + "leftover values = " + explicitValuesSet);
        }
    }

    public static <T extends Enum<?>> Maybe<T> valueOfIgnoreCase(Class<T> type, String givenValue) {
        return Enums.valueOfIgnoreCase((String)JavaClassNames.simpleClassName(type), (Enum[])Enums.values(type), (String)givenValue);
    }

    public static <T extends Enum<?>> Maybe<T> valueOfIgnoreCase(String contextMessage, T[] enumValues, String givenValue) {
        if (givenValue == null) {
            return Maybe.absent(new IllegalStateException("Value for " + contextMessage + " must not be null"));
        }
        if (Strings.isBlank(givenValue)) {
            return Maybe.absent(new IllegalStateException("Value for " + contextMessage + " must not be blank"));
        }
        for (T v : enumValues) {
            if (!((Enum)v).name().equals(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!((Enum)v).toString().equals(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!((Enum)v).name().equalsIgnoreCase(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!((Enum)v).toString().equalsIgnoreCase(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, ((Enum)v).name()).equals(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, ((Enum)v).toString()).equals(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, ((Enum)v).name()).equalsIgnoreCase(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, ((Enum)v).toString()).equalsIgnoreCase(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ((Enum)v).toString()).equalsIgnoreCase(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ((Enum)v).name()).equals(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ((Enum)v).toString()).equals(givenValue)) continue;
            return Maybe.of(v);
        }
        for (T v : enumValues) {
            if (!CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, ((Enum)v).name()).equalsIgnoreCase(givenValue)) continue;
            return Maybe.of(v);
        }
        return Maybe.absent(new IllegalStateException("Invalid value " + givenValue + " for " + contextMessage));
    }

    private static final class EnumFromStringFunction<T extends Enum<?>>
    implements Function<String, T> {
        private final Class<T> type;

        public EnumFromStringFunction(Class<T> type) {
            this.type = type;
        }

        public T apply(String input) {
            return (T)((Enum)Enums.valueOfIgnoreCase(this.type, input).orNull());
        }
    }

    private static final class EnumToNameFunction
    implements Function<Enum<?>, String> {
        private EnumToNameFunction() {
        }

        public String apply(Enum<?> input) {
            return input.name();
        }
    }
}

