/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.javalang;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class AtomicReferences {
    public static boolean setIfDifferent(AtomicBoolean ref, boolean value) {
        return ref.getAndSet(value) != value;
    }

    public static <T> boolean setIfDifferent(AtomicReference<T> ref, T value) {
        return !Objects.equal(ref.getAndSet(value), value);
    }

    public static <T> Supplier<T> supplier(final AtomicReference<T> ref) {
        Preconditions.checkNotNull(ref);
        return new Supplier<T>(){

            public T get() {
                return ref.get();
            }

            public String toString() {
                return "AtomicRefSupplier";
            }
        };
    }
}

