/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.exceptions;

import brooklyn.util.exceptions.Exceptions;
import com.google.common.annotations.Beta;
import com.google.common.base.Supplier;
import javax.annotation.Nullable;

@Beta
public class ReferenceWithError<T>
implements Supplier<T> {
    private final T object;
    private final Throwable error;
    private final boolean maskError;

    public static <T> ReferenceWithError<T> newInstanceThrowingError(T object, Throwable error) {
        return new ReferenceWithError<T>(object, error, false);
    }

    public static <T> ReferenceWithError<T> newInstanceMaskingError(T object, Throwable error) {
        return new ReferenceWithError<T>(object, error, true);
    }

    public static <T> ReferenceWithError<T> newInstanceWithoutError(T object) {
        return new ReferenceWithError<T>(object, null, false);
    }

    protected ReferenceWithError(@Nullable T object, @Nullable Throwable error, boolean maskError) {
        this.object = object;
        this.error = error;
        this.maskError = maskError;
    }

    public boolean masksErrorIfPresent() {
        return this.maskError;
    }

    public T get() {
        if (this.masksErrorIfPresent()) {
            return this.getWithoutError();
        }
        return this.getWithError();
    }

    public T getWithoutError() {
        return this.object;
    }

    public T getWithError() {
        this.checkNoError();
        return this.object;
    }

    public void checkNoError() {
        if (this.hasError()) {
            Exceptions.propagate(this.error);
        }
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.object + (this.error != null ? "/" + (this.maskError ? "masking:" : "throwing:") + this.error : "") + "]";
    }
}

