/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.exceptions;

import brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagatedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 3959054308510077172L;
    private static final Logger LOG = LoggerFactory.getLogger(PropagatedRuntimeException.class);
    private final boolean causeEmbeddedInMessage;

    public PropagatedRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.warnIfWrapping(cause);
        this.causeEmbeddedInMessage = message.endsWith(Exceptions.collapseText(this.getCause()));
    }

    public PropagatedRuntimeException(String message, Throwable cause, boolean causeEmbeddedInMessage) {
        super(message, cause);
        this.warnIfWrapping(cause);
        this.causeEmbeddedInMessage = causeEmbeddedInMessage;
    }

    public PropagatedRuntimeException(Throwable cause) {
        super("", cause);
        this.warnIfWrapping(cause);
        this.causeEmbeddedInMessage = false;
    }

    private void warnIfWrapping(Throwable cause) {
        if (LOG.isTraceEnabled() && cause instanceof PropagatedRuntimeException) {
            LOG.trace("Wrapping a PropagatedRuntimeException in another PropagatedRuntimeException. Call chain:", (Throwable)new Exception());
        }
    }

    @Override
    public String toString() {
        if (this.causeEmbeddedInMessage) {
            return super.toString();
        }
        return Exceptions.appendSeparator(super.toString(), Exceptions.collapseText(this.getCause()));
    }

    public boolean isCauseEmbeddedInMessage() {
        return this.causeEmbeddedInMessage;
    }
}

