/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.exceptions;

import brooklyn.util.exceptions.CompoundRuntimeException;
import brooklyn.util.exceptions.PropagatedRuntimeException;
import brooklyn.util.exceptions.RuntimeInterruptedException;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class Exceptions {
    private static final List<Class<? extends Throwable>> BORING_THROWABLE_SUPERTYPES = ImmutableList.of(ExecutionException.class, InvocationTargetException.class, PropagatedRuntimeException.class, UndeclaredThrowableException.class);
    private static final Predicate<Throwable> IS_THROWABLE_BORING = new Predicate<Throwable>(){

        public boolean apply(Throwable input) {
            return Exceptions.isBoring(input);
        }
    };
    private static List<Class<? extends Throwable>> BORING_PREFIX_THROWABLE_EXACT_TYPES = ImmutableList.of(IllegalStateException.class, RuntimeException.class, CompoundRuntimeException.class);

    private static boolean isBoring(Throwable t) {
        for (Class<? extends Throwable> type : BORING_THROWABLE_SUPERTYPES) {
            if (!type.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrefixBoring(Throwable t) {
        if (t == null) {
            return false;
        }
        if (Exceptions.isBoring(t)) {
            return true;
        }
        for (Class<? extends Throwable> type : BORING_PREFIX_THROWABLE_EXACT_TYPES) {
            if (!t.getClass().equals(type)) continue;
            return true;
        }
        return false;
    }

    private static String stripBoringPrefixes(String s) {
        ArrayList prefixes = Lists.newArrayListWithCapacity((int)(2 + BORING_PREFIX_THROWABLE_EXACT_TYPES.size() * 3));
        for (Class<? extends Throwable> type : BORING_PREFIX_THROWABLE_EXACT_TYPES) {
            prefixes.add(type.getCanonicalName());
            prefixes.add(type.getName());
            prefixes.add(type.getSimpleName());
        }
        prefixes.add(":");
        prefixes.add(" ");
        String[] ps = prefixes.toArray(new String[prefixes.size()]);
        return Strings.removeAllFromStart(s, ps);
    }

    public static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            throw new RuntimeInterruptedException((InterruptedException)throwable);
        }
        Throwables.propagateIfPossible((Throwable)((Throwable)Preconditions.checkNotNull((Object)throwable)));
        throw new PropagatedRuntimeException(throwable);
    }

    public static void propagateIfFatal(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            throw new RuntimeInterruptedException((InterruptedException)throwable);
        }
        if (throwable instanceof RuntimeInterruptedException) {
            throw (RuntimeInterruptedException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static <T extends Throwable> T getFirstThrowableOfType(Throwable from, Class<T> clazz) {
        return (T)((Throwable)Iterables.tryFind((Iterable)Throwables.getCausalChain((Throwable)from), (Predicate)Predicates.instanceOf(clazz)).orNull());
    }

    public static Throwable getFirstInteresting(Throwable throwable) {
        return (Throwable)Iterables.tryFind((Iterable)Throwables.getCausalChain((Throwable)throwable), (Predicate)Predicates.not(IS_THROWABLE_BORING)).or((Object)throwable);
    }

    public static Throwable collapse(Throwable source) {
        return Exceptions.collapse(source, true);
    }

    public static Throwable collapseIncludingAllCausalMessages(Throwable source) {
        return Exceptions.collapse(source, true, true);
    }

    public static Throwable collapse(Throwable source, boolean collapseCausalChain) {
        return Exceptions.collapse(source, collapseCausalChain, false);
    }

    private static Throwable collapse(Throwable source, boolean collapseCausalChain, boolean includeAllCausalMessages) {
        Throwable messagesCause;
        String message = "";
        Throwable collapsed = source;
        int collapseCount = 0;
        boolean messageIsFinal = false;
        while (Exceptions.isBoring(collapsed) && !messageIsFinal) {
            ++collapseCount;
            Throwable cause = collapsed.getCause();
            if (cause == null) {
                return source;
            }
            String collapsedS = collapsed.getMessage();
            if (collapsed instanceof PropagatedRuntimeException && ((PropagatedRuntimeException)collapsed).isCauseEmbeddedInMessage()) {
                message = collapsed.getMessage();
                messageIsFinal = true;
            } else if (Strings.isNonBlank(collapsedS)) {
                collapsedS = Strings.removeFromEnd(collapsedS, cause.toString(), Exceptions.stripBoringPrefixes(cause.toString()), cause.getMessage());
                if (Strings.isNonBlank(collapsedS = Exceptions.stripBoringPrefixes(collapsedS))) {
                    message = Exceptions.appendSeparator(message, collapsedS);
                }
            }
            collapsed = cause;
        }
        for (messagesCause = collapsed; messagesCause != null && Exceptions.isPrefixBoring(messagesCause) && Strings.isBlank(message); messagesCause = messagesCause.getCause()) {
            ++collapseCount;
            if (!Strings.isNonBlank(messagesCause.getMessage())) continue;
            message = messagesCause.getMessage();
            messagesCause = messagesCause.getCause();
            break;
        }
        if (collapseCount == 0 && !includeAllCausalMessages) {
            return source;
        }
        if (collapseCount == 0 && messagesCause != null) {
            message = messagesCause.toString();
            messagesCause = messagesCause.getCause();
        }
        if (Strings.isBlank(message)) {
            return new PropagatedRuntimeException(collapseCausalChain ? collapsed : source);
        }
        if (messagesCause != null && !messageIsFinal) {
            String extraMessage = Exceptions.collapseText(messagesCause, includeAllCausalMessages);
            message = Exceptions.appendSeparator(message, extraMessage);
        }
        return new PropagatedRuntimeException(message, collapseCausalChain ? collapsed : source, true);
    }

    static String appendSeparator(String message, String next) {
        if (Strings.isBlank(message)) {
            return next;
        }
        if (Strings.isBlank(next)) {
            return message;
        }
        if (message.endsWith(next)) {
            return message;
        }
        if (message.trim().endsWith(":") || message.trim().endsWith(";")) {
            return message.trim() + " " + next;
        }
        return message + ": " + next;
    }

    public static RuntimeException propagateCollapsed(Throwable source) {
        throw Exceptions.propagate(source);
    }

    public static String collapseText(Throwable t) {
        return Exceptions.collapseText(t, false);
    }

    public static String collapseTextIncludingAllCausalMessages(Throwable t) {
        return Exceptions.collapseText(t, true);
    }

    private static String collapseText(Throwable t, boolean includeAllCausalMessages) {
        if (t == null) {
            return null;
        }
        Throwable t2 = Exceptions.collapse(t, true, includeAllCausalMessages);
        if (t2 instanceof PropagatedRuntimeException) {
            if (((PropagatedRuntimeException)t2).isCauseEmbeddedInMessage()) {
                return t2.getMessage();
            }
            if (t2.getCause() != null) {
                return "" + t2.getCause();
            }
            return "" + t2.getClass();
        }
        String result = t2.toString();
        if (!includeAllCausalMessages) {
            return result;
        }
        Throwable cause = t2.getCause();
        if (cause != null) {
            String causeResult = Exceptions.collapseText(new PropagatedRuntimeException(cause));
            if (result.indexOf(causeResult) >= 0) {
                return result;
            }
            return result + "; caused by " + causeResult;
        }
        return result;
    }

    public static RuntimeException propagate(Collection<? extends Throwable> exceptions) {
        throw Exceptions.propagate(Exceptions.create(exceptions));
    }

    public static RuntimeException propagate(String prefix, Collection<? extends Throwable> exceptions) {
        throw Exceptions.propagate(Exceptions.create(prefix, exceptions));
    }

    public static Throwable create(Collection<? extends Throwable> exceptions) {
        return Exceptions.create(null, exceptions);
    }

    public static RuntimeException create(String prefix, Collection<? extends Throwable> exceptions) {
        if (exceptions.size() == 1) {
            Throwable e = exceptions.iterator().next();
            if (Strings.isBlank(prefix)) {
                return new PropagatedRuntimeException(e);
            }
            return new PropagatedRuntimeException(prefix + ": " + Exceptions.collapseText(e), e);
        }
        if (exceptions.isEmpty()) {
            if (Strings.isBlank(prefix)) {
                return new CompoundRuntimeException("(empty compound exception)", exceptions);
            }
            return new CompoundRuntimeException(prefix, exceptions);
        }
        if (Strings.isBlank(prefix)) {
            return new CompoundRuntimeException(exceptions.size() + " errors, including: " + Exceptions.collapseText(exceptions.iterator().next()), exceptions);
        }
        return new CompoundRuntimeException(prefix + ", " + exceptions.size() + " errors including: " + Exceptions.collapseText(exceptions.iterator().next()), exceptions);
    }
}

