/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.crypto;

import brooklyn.util.exceptions.Exceptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.NoSuchElementException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class SecureKeysWithoutBouncyCastle {
    private static KeyPairGenerator defaultKeyPairGenerator = SecureKeysWithoutBouncyCastle.newKeyPairGenerator("RSA", 1024);

    protected SecureKeysWithoutBouncyCastle() {
    }

    public static KeyPairGenerator newKeyPairGenerator(String algorithm, int bits) {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.propagate(e);
        }
        keyPairGenerator.initialize(bits);
        return keyPairGenerator;
    }

    public static KeyPair newKeyPair() {
        return defaultKeyPairGenerator.generateKeyPair();
    }

    public static KeyPair newKeyPair(String algorithm, int bits) {
        return SecureKeysWithoutBouncyCastle.newKeyPairGenerator(algorithm, bits).generateKeyPair();
    }

    public static KeyStore newKeyStore() {
        try {
            KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
            store.load(null, null);
            return store;
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public static KeyStore newKeyStore(InputStream source, String passphrase) {
        try {
            KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
            store.load(source, passphrase != null ? passphrase.toCharArray() : new char[]{});
            return store;
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public static TrustManager getTrustManager(KeyStore trustStore) {
        return SecureKeysWithoutBouncyCastle.getTrustManager(trustStore, null);
    }

    public static <T extends TrustManager> T getTrustManager(KeyStore trustStore, Class<T> type) {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            TrustManager result = null;
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (type != null && !type.isInstance(tm)) continue;
                if (result != null) {
                    throw new IllegalStateException("Multiple trust managers matching " + type + " inferred from " + trustStore);
                }
                result = tm;
            }
            if (result != null) {
                return (T)result;
            }
            throw new NoSuchElementException("No trust manager matching " + type + " can be inferred from " + trustStore);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public static X509TrustManager getTrustManager(X509Certificate certificate) {
        try {
            KeyStore ks = SecureKeysWithoutBouncyCastle.newKeyStore();
            ks.setCertificateEntry("", certificate);
            return SecureKeysWithoutBouncyCastle.getTrustManager(ks, X509TrustManager.class);
        }
        catch (KeyStoreException e) {
            throw Exceptions.propagate(e);
        }
    }

    public static X509Certificate getCanonicalImpl(X509Certificate inCert) {
        try {
            KeyStore store = SecureKeysWithoutBouncyCastle.newKeyStore();
            store.setCertificateEntry("to-canonical", inCert);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            store.store(out, "".toCharArray());
            KeyStore store2 = KeyStore.getInstance(KeyStore.getDefaultType());
            store2.load(new ByteArrayInputStream(out.toByteArray()), "".toCharArray());
            return (X509Certificate)store2.getCertificate("to-canonical");
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public static boolean isCertificateAuthorizedBy(X509Certificate candidate, X509Certificate authority) {
        try {
            candidate = SecureKeysWithoutBouncyCastle.getCanonicalImpl(candidate);
            SecureKeysWithoutBouncyCastle.getTrustManager(authority).checkClientTrusted(new X509Certificate[]{candidate}, "RSA");
            return true;
        }
        catch (CertificateException e) {
            return false;
        }
    }

    public static X500Principal getX500PrincipalWithCommonName(String commonName) {
        return new X500Principal("C=None,L=None,O=None,OU=None,CN=" + commonName);
    }
}

