/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.crypto;

import brooklyn.util.exceptions.Exceptions;
import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class AuthorizedKeysParser {
    public static PublicKey decodePublicKey(String keyLine) {
        try {
            ByteArrayInputStream stream = null;
            for (String part : keyLine.split(" ")) {
                if (!part.startsWith("AAAA")) continue;
                stream = new ByteArrayInputStream(BaseEncoding.base64().decode((CharSequence)part));
                break;
            }
            if (stream == null) {
                throw new IllegalArgumentException("Encoded public key should include phrase beginning AAAA.");
            }
            String type = AuthorizedKeysParser.readType(stream);
            if (type.equals("ssh-rsa")) {
                BigInteger e = AuthorizedKeysParser.readBigInt(stream, 1);
                BigInteger m = AuthorizedKeysParser.readBigInt(stream, 1);
                RSAPublicKeySpec spec = new RSAPublicKeySpec(m, e);
                return KeyFactory.getInstance("RSA").generatePublic(spec);
            }
            if (type.equals("ssh-dss")) {
                BigInteger p = AuthorizedKeysParser.readBigInt(stream, 1);
                BigInteger q = AuthorizedKeysParser.readBigInt(stream, 1);
                BigInteger g = AuthorizedKeysParser.readBigInt(stream, 1);
                BigInteger y = AuthorizedKeysParser.readBigInt(stream, 1);
                DSAPublicKeySpec spec = new DSAPublicKeySpec(y, p, q, g);
                return KeyFactory.getInstance("DSA").generatePublic(spec);
            }
            throw new IllegalArgumentException("Unknown public key type " + type);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal(e);
            throw new IllegalArgumentException("Error parsing authorized_keys/SSH2 format public key: " + e);
        }
    }

    private static int readInt(InputStream stream) throws IOException {
        return (stream.read() & 0xFF) << 24 | (stream.read() & 0xFF) << 16 | (stream.read() & 0xFF) << 8 | stream.read() & 0xFF;
    }

    private static byte[] readBytesWithLength(InputStream stream, int minLen) throws IOException {
        int len = AuthorizedKeysParser.readInt(stream);
        if (len < minLen || len > 100000) {
            throw new IllegalStateException("Invalid stream header: length " + len);
        }
        byte[] result = new byte[len];
        stream.read(result);
        return result;
    }

    private static void writeInt(OutputStream stream, int v) throws IOException {
        for (int shift = 24; shift >= 0; shift -= 8) {
            stream.write(v >>> shift & 0xFF);
        }
    }

    private static void writeBytesWithLength(OutputStream stream, byte[] buf) throws IOException {
        AuthorizedKeysParser.writeInt(stream, buf.length);
        stream.write(buf);
    }

    private static String readType(InputStream stream) throws IOException {
        return new String(AuthorizedKeysParser.readBytesWithLength(stream, 0));
    }

    private static BigInteger readBigInt(InputStream stream, int minLen) throws IOException {
        return new BigInteger(AuthorizedKeysParser.readBytesWithLength(stream, minLen));
    }

    public static String encodePublicKey(PublicKey key) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String type = null;
            if (key == null) {
                return null;
            }
            if (key instanceof RSAPublicKey) {
                type = "ssh-rsa";
                AuthorizedKeysParser.writeBytesWithLength(out, type.getBytes());
                AuthorizedKeysParser.writeBytesWithLength(out, ((RSAPublicKey)key).getPublicExponent().toByteArray());
                AuthorizedKeysParser.writeBytesWithLength(out, ((RSAPublicKey)key).getModulus().toByteArray());
            } else if (key instanceof DSAPublicKey) {
                type = "ssh-dss";
                AuthorizedKeysParser.writeBytesWithLength(out, type.getBytes());
                AuthorizedKeysParser.writeBytesWithLength(out, ((DSAPublicKey)key).getParams().getP().toByteArray());
                AuthorizedKeysParser.writeBytesWithLength(out, ((DSAPublicKey)key).getParams().getQ().toByteArray());
                AuthorizedKeysParser.writeBytesWithLength(out, ((DSAPublicKey)key).getParams().getG().toByteArray());
                AuthorizedKeysParser.writeBytesWithLength(out, ((DSAPublicKey)key).getY().toByteArray());
            } else {
                throw new IllegalStateException("Unsupported public key type for encoding: " + key);
            }
            out.close();
            return type + " " + BaseEncoding.base64().encode(out.toByteArray());
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }
}

