/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.collections;

import brooklyn.util.collections.MutableList;
import brooklyn.util.yaml.Yamls;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public interface QuorumCheck {
    public boolean isQuorate(int var1, int var2);

    public static class LinearRangeQuorumCheck
    implements QuorumCheck,
    Serializable {
        private static final long serialVersionUID = -6425548115925898645L;
        protected final String name;
        protected final List<Point> points;

        public static LinearRangeQuorumCheck of(String name, Iterable<? extends Iterable<Integer>> points) {
            return new LinearRangeQuorumCheck(name, Point.listOfIntegerCoords(points));
        }

        public static LinearRangeQuorumCheck of(Iterable<? extends Iterable<Integer>> points) {
            return new LinearRangeQuorumCheck(null, Point.listOfIntegerCoords(points));
        }

        protected LinearRangeQuorumCheck(String name, Iterable<Point> points) {
            Preconditions.checkArgument((Iterables.size(points) >= 2 ? 1 : 0) != 0, (Object)("At least two points must be supplied for " + name + ": " + points));
            this.name = name;
            this.points = MutableList.copyOf(points).asUnmodifiable();
            Object last = null;
            for (Point p : points) {
                if (last == null || !(p.size <= last.size)) continue;
                throw new IllegalStateException("Points must be supplied in order of increasing totalSize (x coordinate); instead have " + last + " and " + p);
            }
        }

        @Override
        public boolean isQuorate(int sizeHealthy, int totalSize) {
            double minRequiredAtSize;
            Point next = this.points.get(0);
            Point prev = null;
            for (int i = 1; i < this.points.size(); ++i) {
                prev = next;
                next = this.points.get(i);
                if (next.size > (double)totalSize) break;
            }
            return (double)sizeHealthy > (minRequiredAtSize = ((double)totalSize - prev.size) / (next.size - prev.size) * (next.minRequiredAtSize - prev.minRequiredAtSize) + prev.minRequiredAtSize) - 1.0E-9;
        }

        public String toString() {
            return "LinearRangeQuorumCheck[" + (this.name != null ? this.name + ":" : "") + this.points + "]";
        }

        private static class Point {
            final double size;
            final double minRequiredAtSize;

            public Point(double size, double minRequiredAtSize) {
                this.size = size;
                this.minRequiredAtSize = minRequiredAtSize;
            }

            public static Point ofIntegerCoords(Iterable<Integer> coords) {
                Preconditions.checkNotNull((Object)(coords == null ? 1 : 0), (Object)"coords");
                Preconditions.checkArgument((Iterables.size(coords) == 2 ? 1 : 0) != 0, (Object)("A point must consist of two coordinates; invalid data: " + coords));
                Iterator<Integer> ci = coords.iterator();
                return new Point(ci.next().intValue(), ci.next().intValue());
            }

            public static List<Point> listOfIntegerCoords(Iterable<? extends Iterable<Integer>> points) {
                MutableList result = MutableList.of();
                for (Iterable<Integer> iterable : points) {
                    result.add(Point.ofIntegerCoords(iterable));
                }
                return result.asUnmodifiable();
            }

            public String toString() {
                return "(" + this.size + "," + this.minRequiredAtSize + ")";
            }
        }
    }

    public static class NumericQuorumCheck
    implements QuorumCheck,
    Serializable {
        private static final long serialVersionUID = -5090669237460159621L;
        protected final int minRequiredSize;
        protected final double minRequiredRatio;
        protected final boolean allowEmpty;
        protected final String name;

        public NumericQuorumCheck(int minRequiredSize, double minRequiredRatio, boolean allowEmpty) {
            this(minRequiredSize, minRequiredRatio, allowEmpty, null);
        }

        public NumericQuorumCheck(int minRequiredSize, double minRequiredRatio, boolean allowEmpty, String name) {
            this.minRequiredSize = minRequiredSize;
            this.minRequiredRatio = minRequiredRatio;
            this.allowEmpty = allowEmpty;
            this.name = name;
        }

        @Override
        public boolean isQuorate(int sizeHealthy, int totalSize) {
            if (this.allowEmpty && totalSize == 0) {
                return true;
            }
            if (sizeHealthy < this.minRequiredSize) {
                return false;
            }
            return !((double)sizeHealthy < (double)totalSize * this.minRequiredRatio - 1.0E-9);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "QuorumCheck[" + (this.name != null ? this.name + ";" : "") + "require=" + this.minRequiredSize + "," + 100.0 * this.minRequiredRatio + "%" + (this.allowEmpty ? "|0" : "") + "]";
        }
    }

    public static class QuorumChecks {
        private static final List<QuorumCheck> NAMED_CHECKS = MutableList.of(QuorumChecks.all(), QuorumChecks.allAndAtLeastOne(), new QuorumCheck[]{QuorumChecks.atLeastOne(), QuorumChecks.atLeastOneUnlessEmpty(), QuorumChecks.alwaysTrue()});

        public static QuorumCheck all() {
            return new NumericQuorumCheck(0, 1.0, false, "all");
        }

        public static QuorumCheck allAndAtLeastOne() {
            return new NumericQuorumCheck(1, 1.0, false, "allAndAtLeastOne");
        }

        public static QuorumCheck atLeastOne() {
            return new NumericQuorumCheck(1, 0.0, false, "atLeastOne");
        }

        public static QuorumCheck atLeastOneUnlessEmpty() {
            return new NumericQuorumCheck(1, 0.0, true, "atLeastOneUnlessEmpty");
        }

        public static QuorumCheck alwaysTrue() {
            return new NumericQuorumCheck(0, 0.0, true, "alwaysHealthy");
        }

        public static QuorumCheck newInstance(int minRequiredSize, double minRequiredRatio, boolean allowEmpty) {
            return new NumericQuorumCheck(minRequiredSize, minRequiredRatio, allowEmpty);
        }

        public static QuorumCheck newLinearRange(String range) {
            return QuorumChecks.newLinearRange(range, null);
        }

        public static QuorumCheck newLinearRange(String range, String name) {
            return LinearRangeQuorumCheck.of(name, (Iterable)Iterables.getOnlyElement(Yamls.parseAll(range)));
        }

        public static QuorumCheck of(String nameOrRange) {
            if (nameOrRange == null) {
                return null;
            }
            for (QuorumCheck qc : NAMED_CHECKS) {
                if (!(qc instanceof NumericQuorumCheck) || !Objects.equal((Object)nameOrRange, (Object)((NumericQuorumCheck)qc).getName())) continue;
                return qc;
            }
            return QuorumChecks.newLinearRange(nameOrRange);
        }
    }
}

