/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.util.collections;

import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.QuorumCheck;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class CollectionFunctionals {
    public static Supplier<Integer> sizeSupplier(Iterable<?> collection) {
        return new SizeSupplier(collection);
    }

    public static Function<Iterable<?>, Integer> sizeFunction() {
        return CollectionFunctionals.sizeFunction(null);
    }

    public static Function<Iterable<?>, Integer> sizeFunction(Integer valueIfInputNull) {
        return new SizeFunction(valueIfInputNull);
    }

    public static <K> Function<Map<K, ?>, Set<K>> keys() {
        return new KeysOfMapFunction();
    }

    public static <K> Function<Map<K, ?>, Integer> mapSize() {
        return CollectionFunctionals.mapSize(null);
    }

    /*
     * Exception decompiling
     */
    public static <K> Function<Map<K, ?>, Integer> mapSize(Integer valueIfNull) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Predicate<Iterable<?>> equalsSetOf(Object ... target) {
        return CollectionFunctionals.equalsSet(Arrays.asList(target));
    }

    public static Predicate<Iterable<?>> equalsSet(Iterable<?> target) {
        return new EqualsSetPredicate(target);
    }

    public static Predicate<Iterable<?>> sizeEquals(int targetSize) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)targetSize), CollectionFunctionals.sizeFunction());
    }

    /*
     * Exception decompiling
     */
    public static <K> Predicate<Map<K, ?>> mapSizeEquals(int targetSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T, I extends Iterable<T>> Function<I, List<T>> limit(int max) {
        return new LimitFunction(max);
    }

    public static <I, T extends Collection<I>> Predicate<T> contains(I item) {
        return new CollectionContains(item);
    }

    public static <T, TT extends Iterable<T>> Predicate<TT> all(Predicate<T> attributeSatisfies) {
        return CollectionFunctionals.quorum(QuorumCheck.QuorumChecks.all(), attributeSatisfies);
    }

    public static <T, TT extends Iterable<T>> Predicate<TT> quorum(QuorumCheck quorumCheck, Predicate<T> attributeSatisfies) {
        return new QuorumSatisfies(quorumCheck, attributeSatisfies);
    }

    private static final class QuorumSatisfies<I, T extends Iterable<I>>
    implements Predicate<T> {
        private final Predicate<I> itemCheck;
        private final QuorumCheck quorumCheck;

        private QuorumSatisfies(QuorumCheck quorumCheck, Predicate<I> itemCheck) {
            this.itemCheck = (Predicate)Preconditions.checkNotNull(itemCheck, (Object)"itemCheck");
            this.quorumCheck = (QuorumCheck)Preconditions.checkNotNull((Object)quorumCheck, (Object)"quorumCheck");
        }

        public boolean apply(T input) {
            if (input == null) {
                return false;
            }
            int sizeHealthy = 0;
            int totalSize = 0;
            for (Object item : input) {
                ++totalSize;
                if (!this.itemCheck.apply(item)) continue;
                ++sizeHealthy;
            }
            return this.quorumCheck.isQuorate(sizeHealthy, totalSize);
        }

        public String toString() {
            return this.quorumCheck.toString() + "(" + this.itemCheck + ")";
        }
    }

    private static final class CollectionContains<I, T extends Collection<I>>
    implements Predicate<T> {
        private final I item;

        private CollectionContains(I item) {
            this.item = item;
        }

        public boolean apply(T input) {
            if (input == null) {
                return false;
            }
            return input.contains(this.item);
        }

        public String toString() {
            return "contains(" + this.item + ")";
        }
    }

    private static final class LimitFunction<T, I extends Iterable<T>>
    implements Function<I, List<T>> {
        private final int max;

        private LimitFunction(int max) {
            this.max = max;
        }

        public List<T> apply(I input) {
            if (input == null) {
                return null;
            }
            MutableList result = MutableList.of();
            for (Object i : input) {
                result.add(i);
                if (result.size() < this.max) continue;
                return result;
            }
            return result;
        }
    }

    public static final class SizeFunction
    implements Function<Iterable<?>, Integer> {
        private final Integer valueIfInputNull;

        private SizeFunction(Integer valueIfInputNull) {
            this.valueIfInputNull = valueIfInputNull;
        }

        public Integer apply(Iterable<?> input) {
            if (input == null) {
                return this.valueIfInputNull;
            }
            return Iterables.size(input);
        }

        public String toString() {
            return "sizeFunction";
        }
    }

    private static final class SizeSupplier
    implements Supplier<Integer> {
        private final Iterable<?> collection;

        private SizeSupplier(Iterable<?> collection) {
            this.collection = collection;
        }

        public Integer get() {
            return Iterables.size(this.collection);
        }

        public String toString() {
            return "sizeSupplier(" + this.collection + ")";
        }
    }

    private static final class KeysOfMapFunction<K>
    implements Function<Map<K, ?>, Set<K>> {
        private KeysOfMapFunction() {
        }

        public Set<K> apply(Map<K, ?> input) {
            if (input == null) {
                return null;
            }
            return input.keySet();
        }

        public String toString() {
            return "keys";
        }
    }

    private static final class EqualsSetPredicate
    implements Predicate<Iterable<?>> {
        private final Iterable<?> target;

        private EqualsSetPredicate(Iterable<?> target) {
            this.target = target;
        }

        public boolean apply(@Nullable Iterable<?> input) {
            if (input == null) {
                return false;
            }
            return Sets.newHashSet(this.target).equals(Sets.newHashSet(input));
        }
    }
}

