/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.options;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InternetDomainName;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;

public class SoftLayerTemplateOptions
extends TemplateOptions
implements Cloneable {
    protected String domainName = "jclouds.org";
    protected Optional<List<Integer>> blockDevices = Optional.absent();
    protected Optional<String> diskType = Optional.absent();
    protected Optional<Integer> portSpeed = Optional.absent();
    protected Optional<String> userData = Optional.absent();
    protected Optional<Integer> primaryNetworkComponentNetworkVlanId = Optional.absent();
    protected Optional<Integer> primaryBackendNetworkComponentNetworkVlanId = Optional.absent();
    protected Optional<Boolean> hourlyBillingFlag = Optional.absent();
    protected Optional<Boolean> dedicatedAccountHostOnlyFlag = Optional.absent();
    protected Optional<Boolean> privateNetworkOnlyFlag = Optional.absent();
    protected Optional<String> postInstallScriptUri = Optional.absent();
    protected Optional<List<Integer>> sshKeys = Optional.absent();
    public static final SoftLayerTemplateOptions NONE = new SoftLayerTemplateOptions();

    public SoftLayerTemplateOptions clone() {
        SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof SoftLayerTemplateOptions) {
            SoftLayerTemplateOptions eTo = (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(to);
            eTo.domainName(this.domainName);
            if (this.blockDevices.isPresent()) {
                eTo.blockDevices((Iterable)this.blockDevices.get());
            }
            if (this.diskType.isPresent()) {
                eTo.diskType((String)this.diskType.get());
            }
            if (this.portSpeed.isPresent()) {
                eTo.portSpeed((Integer)this.portSpeed.get());
            }
            if (this.userData.isPresent()) {
                eTo.userData((String)this.userData.get());
            }
            if (this.primaryNetworkComponentNetworkVlanId.isPresent()) {
                eTo.primaryNetworkComponentNetworkVlanId((Integer)this.primaryNetworkComponentNetworkVlanId.get());
            }
            if (this.primaryBackendNetworkComponentNetworkVlanId.isPresent()) {
                eTo.primaryBackendNetworkComponentNetworkVlanId((Integer)this.primaryBackendNetworkComponentNetworkVlanId.get());
            }
            if (this.hourlyBillingFlag.isPresent()) {
                eTo.hourlyBillingFlag((Boolean)this.hourlyBillingFlag.get());
            }
            if (this.dedicatedAccountHostOnlyFlag.isPresent()) {
                eTo.dedicatedAccountHostOnlyFlag((Boolean)this.dedicatedAccountHostOnlyFlag.get());
            }
            if (this.privateNetworkOnlyFlag.isPresent()) {
                eTo.privateNetworkOnlyFlag((Boolean)this.privateNetworkOnlyFlag.get());
            }
            if (this.sshKeys.isPresent()) {
                eTo.sshKeys((Iterable)this.sshKeys.get());
            }
        }
    }

    public SoftLayerTemplateOptions domainName(String domainName) {
        Preconditions.checkNotNull((Object)domainName, (Object)"domainName was null");
        Preconditions.checkArgument((boolean)InternetDomainName.from((String)domainName).hasPublicSuffix(), (String)"domainName %s has no public suffix", (Object[])new Object[]{domainName});
        this.domainName = domainName;
        return this;
    }

    public SoftLayerTemplateOptions blockDevices(Iterable<Integer> capacities) {
        for (Integer capacity : (Iterable)Preconditions.checkNotNull(capacities, (Object)"capacities")) {
            Preconditions.checkNotNull((Object)capacity, (Object)"all block devices must be non-empty");
        }
        this.blockDevices = Optional.of((Object)ImmutableList.copyOf(capacities));
        return this;
    }

    public SoftLayerTemplateOptions blockDevices(Integer ... capacities) {
        return this.blockDevices((Iterable<Integer>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)capacities, (Object)"capacities"))));
    }

    public SoftLayerTemplateOptions diskType(String diskType) {
        Preconditions.checkNotNull((Object)diskType, (Object)"diskType was null");
        this.diskType = Optional.of((Object)diskType);
        return this;
    }

    public SoftLayerTemplateOptions portSpeed(Integer portSpeed) {
        Preconditions.checkNotNull((Object)portSpeed, (Object)"portSpeed was null");
        this.portSpeed = Optional.of((Object)portSpeed);
        return this;
    }

    public SoftLayerTemplateOptions userData(String userData) {
        Preconditions.checkNotNull((Object)userData, (Object)"userData was null");
        this.userData = Optional.of((Object)userData);
        return this;
    }

    public SoftLayerTemplateOptions primaryNetworkComponentNetworkVlanId(Integer primaryNetworkComponentNetworkVlanId) {
        Preconditions.checkNotNull((Object)primaryNetworkComponentNetworkVlanId, (Object)"primaryNetworkComponentNetworkVlanId was null");
        this.primaryNetworkComponentNetworkVlanId = Optional.of((Object)primaryNetworkComponentNetworkVlanId);
        return this;
    }

    public SoftLayerTemplateOptions primaryBackendNetworkComponentNetworkVlanId(Integer primaryBackendNetworkComponentNetworkVlanId) {
        Preconditions.checkNotNull((Object)primaryBackendNetworkComponentNetworkVlanId, (Object)"primaryBackendNetworkComponentNetworkVlanId was null");
        this.primaryBackendNetworkComponentNetworkVlanId = Optional.of((Object)primaryBackendNetworkComponentNetworkVlanId);
        return this;
    }

    public SoftLayerTemplateOptions hourlyBillingFlag(boolean hourlyBillingFlag) {
        Preconditions.checkNotNull((Object)hourlyBillingFlag, (Object)"hourlyBillingFlag was null");
        this.hourlyBillingFlag = Optional.of((Object)hourlyBillingFlag);
        return this;
    }

    public SoftLayerTemplateOptions dedicatedAccountHostOnlyFlag(boolean dedicatedAccountHostOnlyFlag) {
        Preconditions.checkNotNull((Object)dedicatedAccountHostOnlyFlag, (Object)"dedicatedAccountHostOnlyFlag was null");
        this.dedicatedAccountHostOnlyFlag = Optional.of((Object)dedicatedAccountHostOnlyFlag);
        return this;
    }

    public SoftLayerTemplateOptions privateNetworkOnlyFlag(boolean privateNetworkOnlyFlag) {
        Preconditions.checkNotNull((Object)privateNetworkOnlyFlag, (Object)"privateNetworkOnlyFlag was null");
        this.privateNetworkOnlyFlag = Optional.of((Object)privateNetworkOnlyFlag);
        return this;
    }

    public SoftLayerTemplateOptions postInstallScriptUri(String postInstallScriptUri) {
        Preconditions.checkNotNull((Object)postInstallScriptUri, (Object)"postInstallScriptUri was null");
        this.postInstallScriptUri = Optional.of((Object)postInstallScriptUri);
        return this;
    }

    public SoftLayerTemplateOptions sshKeys(Iterable<Integer> sshKeys) {
        for (Integer sshKey : (Iterable)Preconditions.checkNotNull(sshKeys, (Object)"sshKeys")) {
            Preconditions.checkNotNull((Object)sshKey, (Object)"sshKeys must be non-empty");
        }
        this.sshKeys = Optional.of((Object)ImmutableList.copyOf(sshKeys));
        return this;
    }

    public SoftLayerTemplateOptions sshKeys(Integer ... sshKeys) {
        return this.sshKeys((Iterable<Integer>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)sshKeys, (Object)"sshKeys"))));
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Optional<List<Integer>> getBlockDevices() {
        return this.blockDevices;
    }

    public Optional<String> getDiskType() {
        return this.diskType;
    }

    public Optional<Integer> getPortSpeed() {
        return this.portSpeed;
    }

    public Optional<String> getUserData() {
        return this.userData;
    }

    public Optional<Integer> getPrimaryNetworkComponentNetworkVlanId() {
        return this.primaryNetworkComponentNetworkVlanId;
    }

    public Optional<Integer> getPrimaryBackendNetworkComponentNetworkVlanId() {
        return this.primaryBackendNetworkComponentNetworkVlanId;
    }

    public Optional<Boolean> isHourlyBillingFlag() {
        return this.hourlyBillingFlag;
    }

    public Optional<Boolean> isDedicatedAccountHostOnlyFlag() {
        return this.dedicatedAccountHostOnlyFlag;
    }

    public Optional<Boolean> isPrivateNetworkOnlyFlag() {
        return this.privateNetworkOnlyFlag;
    }

    public Optional<String> getPostInstallScriptUri() {
        return this.postInstallScriptUri;
    }

    public Optional<List<Integer>> getSshKeys() {
        return this.sshKeys;
    }

    public SoftLayerTemplateOptions blockOnPort(int port, int seconds) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public SoftLayerTemplateOptions inboundPorts(int ... ports) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public SoftLayerTemplateOptions authorizePublicKey(String publicKey) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public SoftLayerTemplateOptions installPrivateKey(String privateKey) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public SoftLayerTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public SoftLayerTemplateOptions userMetadata(String key, String value) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public SoftLayerTemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public SoftLayerTemplateOptions networks(Iterable<String> networks) {
        return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(super.networks(networks));
    }

    public static class Builder {
        public static SoftLayerTemplateOptions domainName(String domainName) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.domainName(domainName));
        }

        public static SoftLayerTemplateOptions blockDevices(Integer ... capacities) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.blockDevices(capacities));
        }

        public static SoftLayerTemplateOptions blockDevices(Iterable<Integer> capacities) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.blockDevices(capacities));
        }

        public static SoftLayerTemplateOptions diskType(String diskType) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.diskType(diskType));
        }

        public static SoftLayerTemplateOptions portSpeed(Integer portSpeed) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.portSpeed(portSpeed));
        }

        public static SoftLayerTemplateOptions userData(String userData) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.userData(userData));
        }

        public static SoftLayerTemplateOptions primaryNetworkComponentNetworkVlanId(Integer primaryNetworkComponentNetworkVlanId) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.primaryNetworkComponentNetworkVlanId(primaryNetworkComponentNetworkVlanId));
        }

        public static SoftLayerTemplateOptions primaryBackendNetworkComponentNetworkVlanId(Integer primaryBackendNetworkComponentNetworkVlanId) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.primaryBackendNetworkComponentNetworkVlanId(primaryBackendNetworkComponentNetworkVlanId));
        }

        public static SoftLayerTemplateOptions hourlyBillingFlag(boolean hourlyBillingFlag) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.hourlyBillingFlag(hourlyBillingFlag));
        }

        public static SoftLayerTemplateOptions dedicatedAccountHostOnlyFlag(boolean dedicatedAccountHostOnlyFlag) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.dedicatedAccountHostOnlyFlag(dedicatedAccountHostOnlyFlag));
        }

        public static SoftLayerTemplateOptions privateNetworkOnlyFlag(boolean privateNetworkOnlyFlag) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.privateNetworkOnlyFlag(privateNetworkOnlyFlag));
        }

        public static SoftLayerTemplateOptions postInstallScriptUri(String postInstallScriptUri) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.postInstallScriptUri(postInstallScriptUri));
        }

        public static SoftLayerTemplateOptions sshKeys(Integer ... sshKeys) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.sshKeys(sshKeys));
        }

        public static SoftLayerTemplateOptions sshKeys(Iterable<Integer> sshKeys) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.blockDevices(sshKeys));
        }

        public static SoftLayerTemplateOptions inboundPorts(int ... ports) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static SoftLayerTemplateOptions blockOnPort(int port, int seconds) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static SoftLayerTemplateOptions userMetadata(Map<String, String> userMetadata) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static SoftLayerTemplateOptions userMetadata(String key, String value) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.userMetadata(key, value));
        }

        public static SoftLayerTemplateOptions nodeNames(Iterable<String> nodeNames) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.nodeNames((Iterable)nodeNames));
        }

        public static SoftLayerTemplateOptions networks(Iterable<String> networks) {
            SoftLayerTemplateOptions options = new SoftLayerTemplateOptions();
            return (SoftLayerTemplateOptions)SoftLayerTemplateOptions.class.cast(options.networks((Iterable)networks));
        }
    }
}

