/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy;

import brooklyn.basic.AbstractBrooklynObjectSpec;
import brooklyn.config.ConfigKey;
import brooklyn.management.Task;
import brooklyn.policy.Policy;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicySpec<T extends Policy>
extends AbstractBrooklynObjectSpec<T, PolicySpec<T>> {
    private static final Logger log = LoggerFactory.getLogger(PolicySpec.class);
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> flags = Maps.newLinkedHashMap();
    private final Map<ConfigKey<?>, Object> config = Maps.newLinkedHashMap();

    public static <T extends Policy> PolicySpec<T> create(Class<T> type) {
        return new PolicySpec<T>(type);
    }

    public static <T extends Policy> PolicySpec<T> create(Map<?, ?> config, Class<T> type) {
        return PolicySpec.create(type).configure(config);
    }

    protected PolicySpec(Class<T> type) {
        super(type);
    }

    @Override
    protected void checkValidType(Class<? extends T> type) {
        this.checkIsImplementation(type, Policy.class);
        this.checkIsNewStyleImplementation(type);
    }

    public PolicySpec<T> uniqueTag(String uniqueTag) {
        this.flags.put("uniqueTag", uniqueTag);
        return this;
    }

    public PolicySpec<T> configure(Map<?, ?> val) {
        for (Map.Entry<?, ?> entry : val.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("Null key not permitted");
            }
            if (entry.getKey() instanceof CharSequence) {
                this.flags.put(entry.getKey().toString(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey) {
                this.config.put((ConfigKey)entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey.HasConfigKey) {
                this.config.put(((ConfigKey.HasConfigKey)entry.getKey()).getConfigKey(), entry.getValue());
                continue;
            }
            log.warn("Spec " + this + " ignoring unknown config key " + entry.getKey());
        }
        return this;
    }

    public PolicySpec<T> configure(CharSequence key, Object val) {
        this.flags.put(((CharSequence)Preconditions.checkNotNull((Object)key, (Object)"key")).toString(), val);
        return this;
    }

    public <V> PolicySpec<T> configure(ConfigKey<V> key, V val) {
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this;
    }

    public <V> PolicySpec<T> configureIfNotNull(ConfigKey<V> key, V val) {
        return val != null ? this.configure(key, val) : this;
    }

    public <V> PolicySpec<T> configure(ConfigKey<V> key, Task<? extends V> val) {
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this;
    }

    public <V> PolicySpec<T> configure(ConfigKey.HasConfigKey<V> key, V val) {
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this;
    }

    public <V> PolicySpec<T> configure(ConfigKey.HasConfigKey<V> key, Task<? extends V> val) {
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this;
    }

    public Map<String, ?> getFlags() {
        return Collections.unmodifiableMap(this.flags);
    }

    public Map<ConfigKey<?>, Object> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }
}

