/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy;

import brooklyn.basic.AbstractBrooklynObjectSpec;
import brooklyn.config.ConfigKey;
import brooklyn.management.Task;
import brooklyn.policy.Enricher;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnricherSpec<T extends Enricher>
extends AbstractBrooklynObjectSpec<T, EnricherSpec<T>> {
    private static final Logger log = LoggerFactory.getLogger(EnricherSpec.class);
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> flags = Maps.newLinkedHashMap();
    private final Map<ConfigKey<?>, Object> config = Maps.newLinkedHashMap();

    public static <T extends Enricher> EnricherSpec<T> create(Class<? extends T> type) {
        return new EnricherSpec<T>(type);
    }

    public static <T extends Enricher> EnricherSpec<T> create(Map<?, ?> config, Class<? extends T> type) {
        return EnricherSpec.create(type).configure(config);
    }

    protected EnricherSpec(Class<? extends T> type) {
        super(type);
    }

    @Override
    protected void checkValidType(Class<? extends T> type) {
        this.checkIsImplementation(type, Enricher.class);
        this.checkIsNewStyleImplementation(type);
    }

    public EnricherSpec<T> uniqueTag(String uniqueTag) {
        this.flags.put("uniqueTag", uniqueTag);
        return this;
    }

    public EnricherSpec<T> configure(Map<?, ?> val) {
        for (Map.Entry<?, ?> entry : val.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("Null key not permitted");
            }
            if (entry.getKey() instanceof CharSequence) {
                this.flags.put(entry.getKey().toString(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey) {
                this.config.put((ConfigKey)entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getKey() instanceof ConfigKey.HasConfigKey) {
                this.config.put(((ConfigKey.HasConfigKey)entry.getKey()).getConfigKey(), entry.getValue());
                continue;
            }
            log.warn("Spec " + this + " ignoring unknown config key " + entry.getKey());
        }
        return this;
    }

    public EnricherSpec<T> configure(CharSequence key, Object val) {
        this.flags.put(((CharSequence)Preconditions.checkNotNull((Object)key, (Object)"key")).toString(), val);
        return this;
    }

    public <V> EnricherSpec<T> configure(ConfigKey<V> key, V val) {
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this;
    }

    public <V> EnricherSpec<T> configureIfNotNull(ConfigKey<V> key, V val) {
        return val != null ? this.configure(key, val) : this;
    }

    public <V> EnricherSpec<T> configure(ConfigKey<V> key, Task<? extends V> val) {
        this.config.put((ConfigKey<?>)Preconditions.checkNotNull(key, (Object)"key"), val);
        return this;
    }

    public <V> EnricherSpec<T> configure(ConfigKey.HasConfigKey<V> key, V val) {
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this;
    }

    public <V> EnricherSpec<T> configure(ConfigKey.HasConfigKey<V> key, Task<? extends V> val) {
        this.config.put(((ConfigKey.HasConfigKey)Preconditions.checkNotNull(key, (Object)"key")).getConfigKey(), val);
        return this;
    }

    public Map<String, ?> getFlags() {
        return Collections.unmodifiableMap(this.flags);
    }

    public Map<ConfigKey<?>, Object> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public static abstract class ExtensibleEnricherSpec<T extends Enricher, K extends ExtensibleEnricherSpec<T, K>>
    extends EnricherSpec<T> {
        private static final long serialVersionUID = -3649347642882809739L;

        protected ExtensibleEnricherSpec(Class<? extends T> type) {
            super(type);
        }

        @Override
        protected K self() {
            return (K)this;
        }

        public K uniqueTag(String uniqueTag) {
            super.uniqueTag(uniqueTag);
            return (K)this.self();
        }

        public K configure(Map<?, ?> val) {
            super.configure(val);
            return (K)this.self();
        }

        public K configure(CharSequence key, Object val) {
            super.configure(key, val);
            return (K)this.self();
        }

        public <V> K configure(ConfigKey<V> key, V val) {
            super.configure(key, val);
            return (K)this.self();
        }

        public <V> K configureIfNotNull(ConfigKey<V> key, V val) {
            super.configureIfNotNull(key, val);
            return (K)this.self();
        }

        public <V> K configure(ConfigKey<V> key, Task<? extends V> val) {
            super.configure(key, val);
            return (K)this.self();
        }

        public <V> K configure(ConfigKey.HasConfigKey<V> key, V val) {
            super.configure(key, val);
            return (K)this.self();
        }

        public <V> K configure(ConfigKey.HasConfigKey<V> key, Task<? extends V> val) {
            super.configure(key, val);
            return (K)this.self();
        }
    }
}

